<?php

namespace Clevercherry\Backslash4\Traits;

trait metaTrait
{
	/**
	 * Returns the meta description for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaDescription() : string
	{
		return config('app.name');
	}

	/**
	 * Returns the meta title for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaTitle() : string
	{
		return config('app.name');
	}

	/**
	 * Returns the meta thumbnail for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaThumbnail() : string
	{
		return url('images/logo.png');
	}
}
