<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use App\Models\Page;

class PageController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $item = Page::where('slug', '')->active()->first();
        if($item==null)
            $item = Page::where('slug', '/')->active()->first();

        if(!$item)
        {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0))
        { 
            if(view()->exists('tenant::pages.index'))
                return view('tenant::pages.index')->with('item', $item);
            //else
            if(view()->exists('tenant::pages.view'))
                return view('tenant::pages.view')->with('item', $item);
        }
        //else

        if(view()->exists('pages.index'))
            return view('pages.index')->with('item', $item);
        //else
        if(view()->exists('pages.view'))
            return view('pages.view')->with('item', $item);
        // else
        return view('backslash4::generic.view')->with('item', $item);
    }

    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        $item = Page::where('slug', end($params))->active()->first();
        
        if(!$item)
        {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::pages.view'))
            return view('tenant::pages.view')->with('item', $item);
        //else

        if(view()->exists('pages.view'))
            return view('pages.view')->with('item', $item);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }

    public function viewEnquiryThankYou(Request $request)
    {
        return $this->view($request->path());
    }
 
    /**
     * Creates a dynamic robots.txt file based on the current APP_ENV setting
     * @return type
     */
    public function robots()
    {
        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::robots'))
            $content = View::make('tenant::robots');
        else if(view()->exists('robots'))
            $content = View::make('robots');
        else
            $content = View::make('backslash4::robots');
        
        return Response::make($content)->header('Content-Type', 'text/plain;charset=utf-8');
    }

    /**
     * Returns a view of the XML sitemap for search engines
     * @return type
     */
    public function sitemap()
    {
        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::sitemap.xml'))
            $content = View::make('tenant::sitemap.xml');
        else if(view()->exists('sitemap.xml'))
            $content = View::make('sitemap.xml');
        else
            $content = View::make('backslash4::sitemap.xml');

        return Response::make($content)->header('Content-Type', 'text/xml;charset=utf-8');
    }
}
