<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Blog;

class BlogController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = Blog::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::blogs.index'))
            return view('tenant::blogs.index')->with('items', $items);
        //else

        if(view()->exists('blogs.index'))
            return view('blogs.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     */
    public function view(...$params)
    {
        $item = Blog::where('slug', end($params))->active()->first();

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::blogs.view'))
            return view('blogs.view')->with('item', $item);
        //else

        if(view()->exists('blogs.view'))
            return view('blogs.view')->with('item', $item);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
}
