@props([
  'active' => false,
  'dropdown' => false,
  'icon' => false,
  'label' => null,
  'link' => null
])

@php
    $attributes = $attributes
        ->merge([
            'href' => $link,
            'data-active' => $active,
        ])
        ->class([
            'navigation__item-link'
        ]);
@endphp

<li class="navigation__item">
    <a {{ $attributes }}
        @if($dropdown) 
          data-dropdown="true" 
          aria-expanded="false"
        @endif >
    
        @if($icon != false)
            <x-bs-icon             
                :icon="$icon" 
                size="sm" 
            />
        @endif
    
        <span class="navigation__item-text">
            {{ $label }}
        </span>
        
        @if($dropdown)
            <x-bs-icon             
                icon="chevron-down" 
                size="sm" 
            />
        @endif
    </a>
    @if ($dropdown)
            {{ $slot }}
    @else
        {{ $slot }}
    @endif
</li>