@props([
    'item' => null,
    'fieldname' => '',
    'hiddenFilters' => [],
])
@php
    $fieldtype = $item->getFieldType($fieldname);
    $fieldtab = $item->getFieldTab($fieldname);
    
    //the actual value
    $attr = $item->getAttribute($fieldname);
    if($attr===null)
    { 
        //although this function exists you proabbly want to do something in the constructor
        $attr = $item->getDefaultFieldValue($fieldname, null);
    }

    $required = $item->getFieldRequired($fieldname);

    $label = $item->translateFieldName($fieldname) . (!empty($required) ? ' *' : '');
    if(false)  //debug
        $label .= '['.$item->getAttribute($fieldname).']';

    $hint = $item->getHintText($fieldname);
    $placeholder = $item->getPlaceholderText($fieldname);
    $modelName = Str::Singular($item->getTable());
    $readonly=null;
    $disabled=null;
    if( Str::endsWith($fieldtype,":readonly") || Str::endsWith($fieldtype,":read-only") )
    {   $readonly=true;
        $disabled=true;
        $fieldtype = explode(":",$fieldtype,2)[0];
    }
    $extraAttributes = @$item->getFieldAttributes($fieldname) ?? 'test="90210"';

    //insert extra html before and after field
    
    $renderBeforeField = @$item->renderBeforeField($fieldname) ?? '';
    $renderAfterField = @$item->renderAfterField($fieldname) ?? '';
    $fieldwidth = @$item->getFieldWidth($fieldname) ?? 'col-span-1';

    
@endphp
{!! $renderBeforeField  !!}
@switch($fieldtype)
    @case('id')
        @if(!empty($attr))
            <x-bs-form.id :value=$attr />
        @endif
        @break
    @case('not-on-form')
        @break
    @case('readonly') {{-- special use case --}}
        <x-bs-form.input 
            type="text"
            readonly disabled 
            :$label :$hint :$extraAttributes :$fieldwidth
            :value=$attr />
        @break
    @case('choose-options-readonly') {{-- special use case --}}
    @case('readonly-choose-options') {{-- special use case --}}
        @php
            $options = $item->getChooseOptions($fieldname);
        @endphp
        <x-bs-form.input
            type="text" 
            readonly disabled
            :$label :$hint :$extraAttributes :$fieldwidth
            value="{{ @$options[$attr] ?? 'null' }}"  
        />
        @break
    @case('hidden')
        <x-bs-form.input 
            type="hidden"
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            label="" 
            :value=$attr
            :$extraAttributes 
        />
        @break
    @case('rich-text-editor')
    @case('rich-text-edit')
    @case('rich-text')
    @case('richtext')
    @case('richtexteditor')
        <x-bs-form.textarea
            richtexteditor 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            :$required :$readonly :$disabled
            :$label :$hint :$extraAttributes >{{ $attr }}</x-bs-form.textarea>
        @break
    @case('text-area')
        <x-bs-form.textarea 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$hint :$extraAttributes >{{ $attr }}</x-bs-form.textarea>
        @break
    @case('check')
    @case('check-box')
        <x-bs-form.check 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            value="1" 
            :checked=$attr
            :$label :$hint :$readonly :$disabled  :$extraAttributes :$fieldwidth
        />
        @break
    @case('switch')        
        <x-bs-form.switch
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            value="1" 
            :switch=$attr 
            :$label :$hint :$readonly :$disabled :$extraAttributes :$fieldwidth
        />
        @break
    @case('choose-option')
    @case('choose-options')
        @php
            //note this will be a text field if the model returned is null, if no list
            $options = $item->getChooseOptions($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text"
                id="{{ $fieldname }}"
                name="{{ $fieldname }}" 
                :value=$attr
                :$label :$hint :$required :$readonly :$disabled :$placeholder :$extraAttributes :$fieldwidth
            />
        @else
            <x-bs-form.select 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :$required :$readonly :$disabled 
                :$label :$hint :$placeholder :$fieldwidth
                firstoption="disabled readonly" :$options  :selected="$attr ?? 0" 
                :$extraAttributes 
            />
        @endif
        @break
    @case('choose-options-checkbox')
        @php
            //note this will be a text field if the model returned is null, if no list
            $options = $item->getChooseOptions($fieldname);
            
            //so that mySQL 'set', which returns a CSV will work -- any CSV in fact
            // note you will have process it anyway in public function checkBeforeSave($store): array
            // as this return an array, which you must either json_encode or implode anyway
            if(!Str::startsWith($attr,'[') && !Str::endsWith($attr,']')
                && !Str::startsWith($attr,'{') && !Str::endsWith($attr,'}'))
                $attr=json_encode(explode(',',$attr));
        @endphp
        @if($options==null)
            <x-bs-form.input
                type="text" 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :$required :$readonly :$disabled
                :$label :$hint :$placeholder :$fieldwidth
                :value=$attr
                :$extraAttributes 
            />
        @else
            <x-bs-form.checkboxes-multiple 
                fieldname="{{ $fieldname }}" 
                :$label 
                :$options 
                :checked=$attr  
                :$extraAttributes 
                :$fieldwidth
            />
        @endif
        @break
    @case('choose-parents')
        @php
            $options = $item->getChooseParents($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text" 
                id="{{ $fieldname }}" name="{{ $fieldname }}"
                :$readonly :$disabled :$required
                :$label :$hint :$placeholder :$extraAttributes :$fieldwidth
                :value=$attr />
        @else
            <x-bs-form.select :$required id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :$readonly :$disabled
                :$label :$hint :$placeholder :$extraAttributes :$fieldwidth
                :$options 
                :selected="$attr ?? 0"  />
        @endif
        @break
    @case('download-file')
        <x-bs-form.download-button
            name="{{ $fieldname }}" 
            :value=$attr
            :item=$item
            :$extraAttributes
        />
        @break
    @case('file-options')
    @case('files-options')
        @php
            $max = ($fieldtype=='file-options') ? '1' : '';
            $type = $item->getFieldUploadTypes($fieldname)
        @endphp
            <x-bs-form.files-upload :$required id="{{ $fieldname }}" name="{{ $fieldname }}" :$label 
                :$readonly :$disabled
                :$max :$hint :$placeholder :$extraAttributes
                :value=$attr 
                :filerequirements=$type 
            />
        @break
    @case('data-list')
        @php
              $options = $item->getDataList($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text"
                id="{{ $fieldname }}" name="{{ $fieldname }}"
                :$required :$readonly :$disabled
                :$label :$hint :$placeholder  :value=$attr  :$extraAttributes 
            />
        @else
            <x-bs-form.datalist 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :$required :$readonly :$disabled
                :$label :$hint :$placeholder :$extraAttributes
                :options="$options"  :selected="$attr ?? 0"   
            />
        @endif
        @break
    @case('tag-select')
        @php
              $options = $item->getTagList($fieldname);
        @endphp
            <x-bs-form.tag-select
                id="{{ $fieldname }}" 
                name="{{ $fieldname }}" 
                :$required
                :$readonly 
                :$disabled
                :$label 
                :$hint 
                :$placeholder
                :$extraAttributes
                :$fieldwidth
                :options="$options"  
                :selected="$attr ?? 0"
                :multiValue=false
            />
        @break
    @case('address')
        @php
            $options = $item->getChooseOptions($fieldname);
        @endphp
            <x-bs-form.address
                bs4address
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :$required  :$readonly :$disabled
                :$label :$hint :$placeholder :$extraAttributes
                :value="$attr ?? '{}' " 
                firstoption="disabled readonly" :$options  />
        @break
    @case('map-pins')
        <x-bs-maps.google-pin-editor
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$hint :$placeholder :$extraAttributes 
            :value=$attr
            />
        @break
    @case('money') {{-- prices stored in pennies --}}
        <x-bs-form.input 
            type="number"
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$hint :$placeholder 
            step="0.01" 
            value="{{ number_format(round($attr,0)/100,2, '.', '') }}"
            :$extraAttributes  
            :$fieldwidth
        />
        @break
    @case('number')
        <x-bs-form.input 
            type="number" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$hint :$placeholder 
            step="any"
            :value=$attr
            :$extraAttributes 
            :$fieldwidth
        />
        @break
    @case('lat-long-lookup')
        <x-bs-form.lat-long-lookup
            type="number" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$hint :$placeholder 
            step="any"
            :value=$attr
            :$extraAttributes 
            :$fieldwidth
        />
        @break
    @case('password')
        <x-bs-form.input-counted 
            type="password"
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$readonly :$disabled
            :$label :$hint :$extraAttributes 
            placeholder="Password" 
            value=""
            minlength="6"
            :$fieldwidth
        />
        @break
    @case('slug')
        @php
            $menuSlug = Request::getSchemeAndHttpHost().$item->getFrontEndMenuSlug(true);
            if(!Str::endsWith($menuSlug,'/'))
                $menuSlug .='/';
        @endphp
        <x-bs-form.input-counted
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :$readonly {{-- do not use disabled, it will be unset and the code will regenerate it --}}
            :$hint :$label :$placeholder :$extraAttributes
            :text=$menuSlug
            :value=$attr
            :$fieldwidth
        />
        @break
    @case('tag-related')
        @php
            $allothers = $item->getAllOthers();
        @endphp
        <x-bs-form.tag-list 
            type="text" 
            id="{{ $fieldname }}" name="{{ $fieldname }}"
            :alltags=$allothers 
            :$readonly :$disabled
            :$hint :$label :$placeholder :$extraAttributes
            :value=$attr  
            :$fieldwidth
        />
        @break
    @case('tag-field')
        @php
            $fieldtags = $item->getFieldTags($fieldname, true);
        @endphp
        <x-bs-form.tag-list 
            id="{{ $fieldname }}" name="{{ $fieldname }}"
            :alltags=$fieldtags :$readonly :$disabled
            :$hint :$label :$placeholder 
            :value=$attr 
            :$extraAttributes />
        @break
    @case('date')
        <x-bs-form.input 
            type="date" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$placeholder :value=$attr
            step="1"
            :$extraAttributes 
            :$fieldwidth
        />
        @break;
     @case('time')
        <x-bs-form.input 
            type="time" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :$required :$readonly :$disabled
            :$label :$placeholder :value=$attr
            step="1"
            :$extraAttributes 
            :$fieldwidth
        />
        @break; 
    @case('date-time')
        <x-bs-form.input 
            type="datetime-local"
            id="{{ $fieldname }}"
            name="{{ $fieldname }}" 
            :$label :$placeholder :$required :$readonly :$disabled :$extraAttributes
            :value=$attr  
            step="1"
            :$fieldwidth
        />
        @break;
    @case('json')
        <x-bs-form.json name="{{ $fieldname }}" :json=$attr :$fieldwidth />
        @break;
    @case('media')
        @php( $fields = $item->getFieldMediaFields($fieldname) )
        <x-bs-form.media-single 
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname}}" 
            :$label :$readonly :$disabled :$required :$hint :$placeholder 
            :value=$attr 
            :fields=$fields 
            :$extraAttributes />
        @break;
    @case('media-gallery')
        @php( $fields = $item->getFieldMediaFields($fieldname) )
        <x-bs-form.media-multiple 
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :$label 
            :$readonly 
            :$disabled
            :$required 
            :$hint 
            :$placeholder 
            :value=$attr
            :fields=$fields 
            :$extraAttributes />
        @break;
    @case(Str::startsWith($fieldtype, 'custom.'))
        <x-dynamic-component 
            :component="'bs-form.' . $fieldtype" 
            :item="$item" 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            {{--  these, following attributes, may be ignored in your custom edit compoonent getting stuff from item, or can be used --}}
            :$label
            :$placeholder
            :$required 
            :$hint 
            :$readonly 
            :$disabled 
            :value=$attr
            :$extraAttributes 
            :$fieldwidth />
        @break;
    @default
        <x-bs-form.input-counted 
            type="text" 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}" 
            :$hint :$label :$placeholder 
            :$disabled :$readonly :$required  
            maxlength="190" 
            :value=$attr
            :$extraAttributes 
            :$fieldwidth
        />
@endswitch
{!! $renderAfterField  !!}