<?php

namespace Clevercherry\Backslash4\Models;

use \Clevercherry\Backslash4\Models\Model;
use Illuminate\Support\Str;

class Enquiry extends Model
{
    public const  STATE_NEW  = 0;
    public const  STATE_READ = 1;

    /**
     * Override bs4\Model as admins do not have blocks
     */
    public function hasBlocks()
    {
        return false;
    }

    public function getNameTitle() : String
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    /**
     * Return string version of active or status flag
     * @return String      
     */
    public function getStatus() : String
    {
        return ($this->status == self::STATE_NEW) ? "NEW" : "READ";        
    }
    
     /**
     * return 'required' if this field is required - default is required
     * override in the model or model in your app
     */
    public function getFieldRequired($field_name)
    {
        if(in_array($field_name, ['status']))
            return 'required';

        return '';
    }
    
    /**
     * get a list for a select box based upon field_name
     * see product model for an example override
     */
    public function getChooseOptions($field_name)
    {
        if($field_name=='status')
            return [
                '' => 'Select a status',
                self::STATE_NEW => 'New',
                self::STATE_READ => 'Read'
            ];
        //else

        return [];
    }

    /**
     * return the type of the field for use in the generic admin editor
     * overide in your specific model for special use cases
     * see Setting model for an example of overriding
     */
    public function getFieldType($field_name)
    {
        switch($field_name) {
            case 'notes':
                return 'richtexteditor';
            case 'status':
                return 'choose-options';
            case 'key':
                return 'not-on-form';
        }

        return parent::getFieldType($field_name);
    }

    /**
    * return an array widget info
    * @return Array of widget info for display on the admin dashboard
    */
    public static function getDashboardWidgets()
    {
        $widgets=[];

        // $widgets[]=['type'=>'bs-dashboard-widget.info',
        //             'heading'=>"No. of Enquiries",
        //             'text'=> 'All '.self::count('id'),
        //             'widget-order' => 1000
        //           ];
        return $widgets;
    }

    /**
     * extra columns names to be automagiucally added to the listings page, inserted before the dates column
     * @return array       empty array adds no extra columns, 
     *                      array['field_name'] = "label column heading text"
     */
    public static function getExtraListingColumnsA(): array
    {
        return ['email'=>'Email', 'type'=>'Type'];
    }

    /**
     * return a list of fields that should be added to the top of the admin index pages
     * @return Array | null           list of query fieldnames as key, with friendly string names
     *                                [$field_name]="friendly string"
     *                                that will be passd as query parameters or null or empty array
     *                                the fieldnames do not have to reflect the fieldnames in the table, they can be shortened versions that will be passed as request parameters
     *                                as you will also be overriding the scopeIndexSearch function below using the Request() object to get the extra parameters
     */
    public static function getAdminSearchDropDowns() : Array | null
    {
        return ['ty'=>'', 'st'=>''];
    }

    /**
     * return the dropdown list for the above search dropdown key
     * @param  String $field_name        the query fieldname posted when a query is submitted
     * @return Array | null              the list of valid options [value]=String where value is passed in the query, the first option should have a key of the empty string and will be selected by default
     */
    public static function getAdminSearchDropDownList($field_name) : Array | null
    {
        if($field_name=='st')
            return [
                '' => 'Select by Status (All)',
                self::STATE_NEW => 'New',
                self::STATE_READ => 'Read'
            ];

        if($field_name=='ty')
        {
            $types=[];
            $types[''] = 'Select an Enquiry Type (All)';
            foreach(self::select('type')->groupBy('type')->get() as $record)
                if(!empty($record->type))
                    $types[$record->type] = Str::headline($record->type);

            return $types;
        }

        return null;
    }

    /**
     * the standard search scope function which can be overriden to add extra parameters
     * @param         $query
     * @param  String $q
     * @return 
     */
    public function scopeIndexSearch($query, $q)
    {   
        //default enquiry fields
        /*
        $table->String('first_name')->nullable();
        $table->String('last_name')->nullable();
        $table->String('email')->nullable();
        $table->String('phone')->nullable();
        $table->text('message')->nullable();
        $table->String('type')->nullable();
        $table->unsignedBigInteger('key')->nullable();
        $table->text('notes')->nullable();
        $table->integer('status')->default(0);
        */

        $status = Request()->st;
        $type = Request()->ty;
        

        if(!empty($q))
        {
            $q = "%{$q}%";
            $query->where( function($query) use($q) {
            $query->orWhere('first_name', 'like', $q);
            $query->orWhere('last_name', 'like', $q);
            $query->orWhere('email', 'like', $q);
            $query->orWhere('phone', 'like', $q);
            $query->orWhere('message', 'like', $q);
            $query->orWhere('notes', 'like', $q);
            });
        }

        if($status!==null)
            $query->where('status', $status);

        if(!empty($type))
            $query->where('type', $type);

        return $query;
    }
    
}