<x-bs-table.row>
    <x-bs-table.cell>
        <a class="media-item h-24 w-24" 
           href="{{ URL::to('storage/' . $item->original) }}" 
           target="blank" 
           data-overlay="true">
            <div class="media-item__inner">
                <img class="media-item__preview" src="{{ $item->thumbnailUrl() }}">
            </div>
            <div class="media-item__overlay">
                <x-bs-action
                    icon="maximise"
                    size="sm"
                    tag="span"
                    theme="secondary"
                />
            </div>
         </a>
    </x-bs-table.cell>
    <x-bs-table.cell class="[ display-none lg:display-table-cell ]">
        {{ $item->original }}
    </x-bs-table.cell>
    <x-bs-table.cell class="[ display-none md:display-table-cell ]">
        {{ date('j F Y', strtotime($item->created_at)) }}
    </x-bs-table.cell>
    <x-bs-table.cell>
        @if($item->allowEdit())
            <x-bs-button 
                href="{{ route($adminRoute.'.edit',['id'=>$item->id]) }}"
                icon="pencil"
                iconPosition="only"
                size="sm" 
                theme="tertiary" 
                title="Edit this item"
            />
        @endif
        @if($item->allowDelete())
            <x-bs-button 
                icon="trash"
                iconPosition="only"
                size="sm" 
                theme="tertiary" 
                title="Delete this item"
                href="{{ route($adminRoute.'.delete',['id'=>$item->id]) }}" 
                {{-- data-a11y-dialog-show="delete-post-item-mediamanager" --}}
            />
        @endif
    </x-bs-table.cell>
</x-bs-table.row>