<?php

namespace Clevercherry\Backslash4\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Admin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if(! Auth::guard('admin')->check()) {
            return redirect(route('admin.login', ['redirect' => $request->url()]))->withErrors([
                'authentication' => 'Please login to view this page',
            ]);
        }
        return $next($request);
    }
}
