<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Faq;

class FaqController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = Faq::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::faqs.index'))
            return view('tenant::faqs.index')->with('items', $items);
        //else

        if(view()->exists('faqs.index'))
            return view('faqs.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        if( empty(Request()->preview) 
            || empty(Faq::allowPreviewAlgorithm()) 
            ||  (Request()->preview!=hash( Faq::allowPreviewAlgorithm(), end($params)) ) )
        {
            $item = Faq::where('slug', end($params))->active()->first();
        } else
        {
            // preview param exists and matches the slug's hash so allow any pages
            $item = Faq::where('slug', end($params))->first();
        }

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::faqs.view'))
            return view('tenant::faqs.view')->with('item', $item);
        //else

        if(view()->exists('faqs.view'))
            return view('faqs.view')->with('item', $item);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
}
