@props([
    'column' => null,
    'sort' => [],
    'heading' => null
])

@php
    $sort = array_merge([
        'field' => null,
        'order' => 'asc',
        'sorted' => false
    ], $sort);

    $attributes = $attributes
        ->merge([
            'data-column' => $column,
            'data-sort' => isset($sort['field']) ? 'true' : 'false'
        ])
        ->class([
            'table__heading'
        ]);
@endphp

<th {{ $attributes }}>
    @if (isset($sort['field']))
        <x-bs-table.sort
            :heading=$heading
            :field="$sort['field']"
            :order="$sort['order']"
            :sorted="$sort['sorted']"
        />
    @else
        {{ $heading ?? $slot }}
    @endif
</th>