@props([
    'group' => [
        'class' => 'null',
    ],
    'id' => null,
    'label' => null,
    'hint' => '',
    'value' => null,
    'extraAttributes' => '',
])

@php
    $attributes = $attributes
        ->merge([
            'rows' => '5',
        ])
        ->class([
            'textarea',
        ]);
    $hint .= "this will be a hidden text-area with the json data in it";

    $instanceUid=Clevercherry\Backslash4\Backslash4::generateShortUuid();

    if(gettype($extraAttributes)=='string')
        $extraAttributes=[ 'attr' => $extraAttributes ];
              
    $homeLatitude = @$extraAttributes['homeLatitude'] ?? null;
    $homeLongitude = @$extraAttributes['homeLongitude'] ?? null ;
    $homeZoom = @$extraAttributes['homeZoom'] ?? 8 ;
    $apiKey = @$extraAttributes['apikey'] ?? 'AIzaSyAOsDrtcuXqC_CQDp3ZYNDcSiQD_wobTIs';

    if(empty($value))
        $pins=[];
    else
        $pins=json_decode($value);

    $center_lng = 52.4767812;
    $center_lat = -1.9104241;
    $center_avg_cnt = 0;

    $locations=[]; //we will be loading the pins through JS
@endphp

<x-bs-form.group class="{{ $group['class'] }}" data-role="google-pin-editor">
    <div style="width:100%;">
        @php
            if(empty($homeLatitude))
                $homeLatitude = $center_lat;
            
            if(empty($homeLongitude))
                $homeLongitude = $center_lng;
        @endphp
        <div style="width:100%;height:20em;display: block;" data-role="map-container" data-latitude="{{ $homeLatitude }}" data-longitude="{{ $homeLongitude }}">
            <x-bs-maps.google-locations 
                style="width:100%;height:100%;"
                :instanceUid="$instanceUid"
                :locations="$locations"
                :mapsApiKey="$apiKey"
                :homeLatitude ="$homeLatitude "
                :homeLongitude="$homeLongitude"
                :mapZoom="$homeZoom"
                includeDefaultCSS="0"
            />
        </div>
    </div>

    <x-bs-search class="mt-4">
        <textarea data-role="pin-json"
        {{ $id ? 'id="$id"' : '' }}
        {{ $attributes }} style="display:none;"
            @readonly(true) >{{ $value ?? $slot }}
        </textarea>
        <x-bs-search.bar
        />
        <x-bs-search.results data-role="pin-tile-container">
            @php
                $pin = (object) [
                    'name' => 'bs4hidden',
                    'geometry' => (object) [ 'location' => (object) ['lat'=>0 , 'lng'=>0 ] ],
                    'place_id' =>'hidden',
                    'formatted_address' => ''
                ];
                $checked=false;
            @endphp
            <x-bs-maps.pin-location-tile 
                :id
                :pin="$pin"
                :checked="$checked"
                :hidden="true"
            />
            @php
                $pinCount = count($pins);
                $displayStyle = ($pinCount > 0) ? 'display: none;' : '';
            @endphp

            <h3 class="font-regular text-body-tertiary text-sm">Search results (<span data-role="local-area-location-total">{{ count($pins) }}</span>)</h3>
            <x-bs-search.placeholder style="{{ $displayStyle }}">
                <x-bs-featured-icon
                    icon="map"
                    size="lg"
                    theme="secondary"
                    variant="square-border"
                />
                <h3 class="font-semi-bold mt-4 text-body text-md position-relative">Add new locations</h3>
                <p class="mt-1 text-body-tertiary text-sm position-relative">Enter a search term to find nearby locations.</p>
            </x-bs-search.placeholder>
            @foreach($pins as $pin)
                @php
                    if($center_avg_cnt==0) //ork out center from all pins
                    {
                        $center_lng = $pin->geometry->location->lng;
                        $center_lat = $pin->geometry->location->lat;
                        $center_avg_cnt = 1.0;
                    } else
                    {
                        $center_lng = ($center_lng * $center_avg_cnt) +  $pin->geometry->location->lng;
                        $center_lat = ($center_lat * $center_avg_cnt) + $pin->geometry->location->lat;
                        $center_avg_cnt++;
                        $center_lng = $center_lng / $center_avg_cnt;
                        $center_lat = $center_lat / $center_avg_cnt;
                    }
                    $checked= (@$pin->active!==0) ;
                @endphp
                <x-bs-maps.pin-location-tile
                    :id="$id"
                    :pin="$pin"
                    :checked="$checked"
                />
            @endforeach
        </x-bs-search.results>
    </x-bs-search>
    <x-bs-maps.locations-modal />
    <x-bs-alert 
        class="mt-6" 
        data-role="map-success-alert"
        theme="success" 
        show="false"
        @map-success-alert.window="toggle($event.detail)"
    />
    <x-bs-alert 
        class="mt-6" 
        data-role="local-area-map-alert" 
        theme="error" 
        show="false"
        @map-error-alert.window="toggle($event.detail)"
    />
    <x-bs-modal id="add-custom-pin" data-role="maps-editor-newpin-popup">
        <x-bs-modal.header
            direction="row"
            :icon="[
                'icon' => 'map',
                'theme' => 'primary'
            ]"
            title="Add a custom location"
            text="Enter the name and address for the custom map location."
        />
        <x-bs-modal.content>
            <div class="display-grid gap-y-4 grid-cols-1">
                <x-bs-form.input 
                    type="text"
                    label="Location name"
                    data-role="newpin-name"
                />
                <x-bs-form.textarea 
                    label="Location address (optional)"
                    data-role="newpin-address"
                />
            </div>
        </x-bs-modal.content>
        <x-bs-modal.actions>
            <x-bs-button
                size="lg"
                text="Cancel"
                theme="secondary"
                type="button"
                data-a11y-dialog-hide
                aria-label="Close dialog"
            />
            <x-bs-button 
                size="lg"
                text="Add location"
                theme="primary"
                type="button" 
                data-action="maps-editor-newpin-popup-ok"
                data-a11y-dialog-hide 
            />
        </x-bs-modal.actions>
    </x-bs-modal>
</x-bs-form.group>