<?php

namespace Clevercherry\Backslash4\Console\Traits;

trait askWhichTenant
{	

    public function askWhichTenant($zero='', $ninetynine='', $allownull=false)
    {
        $tenants = [];
        $i = 0;
        $this->newLine();
        if(!empty($zero))
        {
            $tenants[0] = $zero;
            $this->info('[0] ' . $zero);
        }
        foreach (config('backslash4.tenants') as $key => $tenantinfo) {
            $tenants[++$i] = $key;
            $this->info('[' . $i . '] ' . $key);
        }
        if(!empty($ninetynine))
        {
            //if we have more than 99 tenants then the $ninetynine option becomes 999, 9999 etc.
            $i=pow(10,max(2,1+floor(log10($i))))-1 ;            
            $tenants[$i] = $ninetynine;
            $this->info('['.$i.'] ' . $ninetynine);
        }
        if($allownull)
            $this->info('[enter] --cancel--');

        $tenant = '';
        $first=true;
        if (!empty($tenants)) {
            while ($first || (!$allownull && $tenant === '')) {
                $first=false;
                $tenant = $this->ask('Select a tenant', '');
            }
            if($tenant==='')
                return '';
            
            return $tenants[$tenant];
        }

        return '';
    }

}