@props([
    'item' => null,
    'injectforms' => true,
    'pageloadjs' => '',
])
@php
// utm_source, utm_medium, utm_campaign, etc.
// https://en.wikipedia.org/wiki/UTM_parameters
// utm_source	Identifies which site sent the traffic, and is a required parameter.
//              utm_source=google
// utm_medium	Identifies what type of link was used, such as email or pay-per-click advertising.
//           	utm_medium=ppc
// utm_campaign	Identifies a specific product promotion or strategic campaign.
//          	utm_campaign=spring_sale
// utm_term 	Identifies search terms.
//           	utm_term=running+shoes
// utm_content	Identifies what specifically was clicked to bring the user to the site,
//              such as a banner ad or a text link. It is often used for A/B testing and 
//              content-targeted ads.
//          	utm_content=logolink or utm_content=textlink

$debug = !empty(request()->bs4journey);

// journey get, update and save functionality is in the User Model
// so that we can override it per application

$journey = \App\Models\User::getUpdatedJourney();

// note: the slot could contain javascript that does other stuff
@endphp
@if(!$slot->isEmpty())
{{ $slot }}
@endif
@if($debug)
<p><pre>DEBUG:REFERER:
{!! json_encode($journey, JSON_PRETTY_PRINT) !!}
</pre></p>
@endif
<script type="text/javascript">
const bs4_InitJourney = () => {
    var input = document.createElement("input");
    input.setAttribute("type", "hidden");
    input.setAttribute("name", "bs4_journey");
    const jvalue = @json($journey);
    input.setAttribute("value", JSON.stringify(jvalue) );

    @if ($injectforms)
    document.querySelectorAll('form').forEach((form) => {
        form.insertAdjacentElement('afterbegin', input.cloneNode(true));
    });
    @endif
    @if(!empty($pageloadjs))
    {{-- javascript snippet here 
      -- possibly calling a bigger JS function in the $slot
      -- such as mycustomfunc(jvalue) --}}
    {!! $pageloadjs !!}
    @endif
};
document.addEventListener('DOMContentLoaded', bs4_InitJourney);
</script>