<x-bs-table.row>
    @if(!in_array('name-title',$hideColumns))
        <td class="table__cell" @if(@$indent) data-indented="true" @endif>
            @if(isset($item->slug) && $item->hasPublicURL())
                    @php($url = empty($item->slug) ? 
                        ( strtolower(Str::plural($type))!='pages' ? strtolower(Str::plural($type)) : '')."/" :
                                $item->getUrl() )
                <span class="display-block font-medium text-body-secondary">
                    {!! $item->getNameTitle() !!}
                </span>
            @else
                {!! $item->getNameTitle() !!}
            @endif
            @if (!empty($url))
                <a class="mt-1 text-link" href="{{ $url }}" target="_blank">
                    @if(isset($item->slug) && $item->hasPublicURL())
                        {{ $url }}
                    @endif
                </a>
            @endif
        </td>
    @endif

    @if(!in_array('author',$hideColumns) && Schema::hasColumn($tableName,'author'))
        <x-bs-table.cell>
            {{ $item->author }}
        </x-bs-table.cell>
    @endif
    @if(!empty($extraColumnsA))
        @foreach($extraColumnsA as $field => $text)
            <x-bs-table.cell>
                @if( method_exists($item, $field) )
                    {!! $item->{$field}() !!}
                @else
                    {{ strip_tags($item->{$field}) }}
                @endif
            </x-bs-table.cell>
        @endforeach
    @endif

    @if(!in_array('status',$hideColumns))
        <x-bs-table.cell class="[ display-none md:display-table-cell ]">
            @if(isset($item->active))
                @if($item->active)
                    <x-bs-badge
                        :icon="[
                            'icon' => 'dot',
                            'position' => 'start'
                        ]"
                        text="{{ $item->getStatus() }}" 
                        theme="success"
                    />
                @else
                    <x-bs-badge
                        :icon="[
                            'icon' => 'dot',
                            'position' => 'start'
                        ]"
                        text="{{ $item->getStatus() }}" 
                        theme="error"
                    />
                @endif
            @elseif(isset($item->status))
                @if($item->status)
                    <x-bs-badge
                        :icon="[
                            'icon' => 'dot',
                            'position' => 'start'
                        ]"
                        text="{{ $item->getStatus() }}" 
                        theme="success"
                    />
                @else
                    <x-bs-badge
                        :icon="[
                            'icon' => 'dot',
                            'position' => 'start'
                        ]"
                        text="{{ $item->getStatus() }}" 
                        theme="error"
                    />
                @endif
            @endif
        </x-bs-table.cell>
    @endif

    @if(!in_array('updated_at',$hideColumns))
        <x-bs-table.cell class="[ display-none lg:display-table-cell ]">
            <p class="text-body-tertiary">
                {{ date('j M Y, H:i', strtotime($item->updated_at)) }}
            </p>
        </x-bs-table.cell>
    @endif
    @if(!empty($extraColumnsB))
        @foreach($extraColumnsB as $field => $text)
            <x-bs-table.cell>
                @if( method_exists($item, $field) )
                {!! $item->{$field}() !!}
                @else
                {{ $item->{$field} }}
                @endif
            </x-bs-table.cell>
        @endforeach
    @endif
    @if($item->orderable())
        <x-bs-table.cell>
            <x-bs-button
                :href="$item->getOrderableUrl($adminRoute, 'up')"
                icon="chevron-up"
                iconPosition="only"
                size="sm"
                theme="secondary"
            />
            <x-bs-button
                :href="$item->getOrderableUrl($adminRoute, 'down')"
                icon="chevron-down"
                iconPosition="only"
                size="sm"
                theme="secondary"
            />
        </x-bs-table.cell>
    @endif
    @if(!in_array('edit',$hideColumns))
        <x-bs-table.cell class="[ text-right ]" style="white-space: nowrap;">
            <x-bs-button 
                :href="$item->getEditUrl($adminRoute)"
                icon="pencil"
                iconPosition="only"
                size="sm" 
                theme="secondary" 
                title="Edit this item"
            />
            @if ($item->allowDelete())
                <x-bs-button 
                    icon="trash"
                    iconPosition="only"
                    size="sm" 
                    theme="secondary"
                    title="Delete this item"
                    :data-delete-url="$item->getDeleteUrl($adminRoute)"
                    data-a11y-dialog-show="delete-post-item-{{ $tableName }}"
                />
            @endif
        </x-bs-table.cell>
    @endif
</x-bs-table.row>

@if($showChildren)
    @foreach($item->getChildren() as $child)
        @include('backslash4::admin.generic.index-item-row', ['item' => $child, 'indent'=> ( isset($indent) ? ($indent+1) : 1 ) ])
    @endforeach
@endif