<?php
namespace Clevercherry\Backslash4\Console;

class Backslash4Uninstall extends Backslash4Command
{
    protected $name = 'backslash:uninstall';
    protected $signature = 'backslash:uninstall';
    protected $description = 'Uninstall Backslash4 and parts thereof';

    public function handle()
    {
        $this->clearMsg();
        $option='999';
        while($option!=='0')
        {
            $this->newLine();
            $this->info('Backslash4 Un-Installer');
            $this->info('-----------------------');
            $this->showStatus();

            $option = $this->showMenu();

            $this->doAction($option);        
        }
    }

    private function showMenu()
    {
        $this->newLine();
        $this->menuLine(0,'Exit Backslash4 Un-Installer');
        $this->menuLine(2,'Show Status');
        $this->menuLine(71,'Delete Config');
        $this->menuLine(72,'Remove Module');
        $this->menuLine(79,'Remove All of Backslash4 from App/Project');
        $this->newLine();

        $this->showMsg();

        return $this->ask('Select a menu option');
    }
}