<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
@foreach(Clevercherry\Backslash4\Backslash4::getDashboardFlatCMS() as $key => $configItem)
	@if(!empty($configItem) && !isset($configItem['html']))
		@php
			$model = false;
			$modelPath = '\App\Models\\' . Str::singular($key);
			if(class_exists($modelPath)) {
				$model = new $modelPath;
			}
		@endphp
		@if($model && $model->includeModelInSitemap() && in_array($sitemap, $model->getSiteMapPages()) )
			@foreach($model->getSiteMapItems() AS $item)
				@if($item->includeInSitemap())
					<url>
					    <loc>{{ strtolower(url($item->getUrl())) }}</loc>
					    <lastmod>{{ gmdate(DateTime::W3C, strtotime($item->updated_at)) }}</lastmod>
					    <changefreq>daily</changefreq>
					    <priority>1.0</priority>
					</url>
				@endif
			@endforeach
			@php
				$additionalUrls = $model->additionalSitemapUrls();
			@endphp
			@if(count($model->additionalSitemapUrls()) > 0)
			@foreach($additionalUrls AS $url)
					<url>
					    <loc>{{ strtolower($url->loc) }}</loc>
					    <lastmod>{{ gmdate(DateTime::W3C, strtotime($url->lastmod)) }}</lastmod>
					    <changefreq>{{ $url->changefreq }}</changefreq>
					    <priority>{{ $url->priority }}</priority>
					</url>
			@endforeach
			@endif
		@endif
	@endif
@endforeach
</urlset>