<x-bs-dashboard>
<main id="maincontent">
    <div class="display-flex flex-col items-start lg:flex-row lg:justify-between">
        <div class="display-flex flex-col">
            <h1 class="font-semi-bold text-gray-900 text-3xl">Upload media</h1>
            <p class="mt-1 text-gray-600">Upload new media to use on this website.</p>
        </div>
        <div class="mt-4 lg:mt-0">
            <x-bs-button 
                href="{{ route('admin.mediamanager.index') }}"
                icon="plus"
                iconPosition="start"
                size="md"
                text="View all" 
                theme="primary"
            />
        </div>
    </div>
    <hr class="divider my-6 md:my-8" />
    @php
        $dirs = \App\Models\MediaManager::getUploadDirectories('', '');
    @endphp

    {{-- Proposed new design --}}

    <h2 class="font-medium text-gray-900 text-lg">Select a folder</h2>
    <p class="mt-1 text-body-tertiary">Choose a folder to upload new media to.</p>
    <div class="display-flex flex-row flex-wrap items-start mt-2" data-previous-value>
        <x-bs-tags.folder class="sr-only" label="--" value="--" />
        @foreach ($dirs as $value => $label)
            <x-bs-tags.folder 
                :label="$label" 
                :value="$value" 
            />
        @endforeach        
    </div>
    <x-bs-tags.add-folder />

    <x-bs-form.dropzone 
        class="mt-6 md:mt-8 sr-only"
        id="media-upload" 
        requirements="{{ \App\Models\MediaManager::getFileRequirements() }}" 
        accept="{{ \App\Models\MediaManager::getFileAccept() }}" 
    />

    <div class="file-queue" data-role="file-queue">
        <div class="display-grid gap-4 grid-cols-1 md:grid-cols-2 lg:grid-cols-3" id="hiddenFileQueueItem">
            <div id="hiddenFileQueueItem" class="sr-only"> 
                <x-bs-file-queue.item />
            </div>
        </div>
    </div>

</main>

<x-bs-modal.add-folder />
<x-bs-modal id="warning-nofolder-modal" size="xl" >
    <x-bs-modal.window>
        <x-bs-modal.header title="Media library" />
        <x-bs-modal.content>
            <div>Please Select a Folder for you Uploads</div>
            <x-bs-modal.footer-ok />
        </x-bs-modal.content>
    </x-bs-modal.window>
</x-bs-modal>

</x-bs-dashboard>