export default () => {
    const groups = document.querySelectorAll('.form-group[data-character-count=true]');

    /**
     * Updates the remaining characters based on the maxlength value minus the
     * input value.
     * 
     * @param {Element} input - form input
     * @param {Element} remaining - remaining characters span
     */

    const updateCount = (input, remaining) => {
        const limit = input.getAttribute('maxlength'),
              length = input.value.length;

        if (!limit) return false;

        remaining.innerHTML = limit - length;
    }

    
    /**
     * 
     * @param {Element} input - form input
     */

    const countError = (input) => {

    }

    groups.forEach((group) => {
        const input = group.querySelector('.input'),
              remaining = group.querySelector('[data-role=remaining-characters]');

        if (!input) return false;

        input.addEventListener('keyup', (event) => {
            updateCount(input, remaining);
        })
    })
}