@php
    // theoretically MediaManager will never be a submodule
    $isTabbedModule = isset($submodule);
@endphp
    <div class="display-flex flex-col items-start lg:flex-row lg:justify-between">
        <div class="display-flex flex-col">
            <h1 class="font-semi-bold text-gray-900 text-3xl">Media library</h1>
            <p class="mt-1 text-gray-600">View media that has been uploaded to this website.</p>
            @php( $extra = ($appModel)::getExtraIndexHeaderView() )
            @php( $hidden = [] )
            @if(!empty($extra))
                <p class="mt-1 text-body-tertiary text-sm">{!! $extra !!}</p>
            @endif
        </div>
        @if($showAdminSearch || $showDropDownSearches)
            <x-bs-js.remove-url-params />
        @endif
        <div class="mt-4 lg:mt-0">
            <x-bs-button 
                href="{{ route('admin.mediamanager.create') }}"
                icon="plus"
                iconPosition="start"
                size="md"
                text="Add new" 
                theme="primary"
            />
        </div>
    </div>
    <hr class="divider my-6 md:my-8" />
    <x-bs-card data-role="{{ ($isTabbedModule) ? '' : 'main-module-container' }}">
        <x-bs-card.header>
            <x-bs-filters x-data="{ open: false }">
                @if($showAdminSearch)
                    <x-bs-filters.item class="lg:display-none" data-role="search" data-filter="search">
                        <x-bs-index-search 
                            label="Search alla {{ str_replace('_', ' ', $tableName) }}"
                            labelVisible="true"
                        />
                    </x-bs-filters.item>
                @endif
                <x-bs-filters.item data-filter="toggle">
                    <x-bs-button
                        type="button"
                        text="Filters"
                        theme="secondary"
                        x-on:click="open = !open"
                    />
                </x-bs-filters.item>
                <x-bs-filters.dropdown x-show="open">
                    @if($showAdminSearch)
                        <x-bs-filters.item class="display-none lg:display-flex" data-role="search" data-filter="search">
                            <x-bs-index-search 
                                label="Search allb {{ str_replace('_', ' ', $tableName) }}"
                                labelVisible="true"
                            />
                        </x-bs-filters.item>
                    @endif
                    @if($showDropDownSearches)
                        <x-bs-filter-search
                            :isTabbedModule=false
                            :searches=$dropDownSearches 
                            :lists=$dropDownSearchLists 
                            :model=$appModel
                            :$hidden
                        />
                    @endif
                </x-bs-filters.dropdown>
                @if($showAdminSearch || $showDropDownSearches)
                    <x-bs-js.remove-url-params />
                @endif
            </x-bs-filters>
        </x-bs-card.header>
        <div class="overflow-scroll" data-role="index-table-container" @if(!$isTabbedModule) data-ajax-href="{{ ($appModel)::getDataAjaxUrl($adminRoute) }}" @endif>
        @if( !$isTabbedModule) {{-- tabbed version will be loaded by ajax after page load time and URLs --}}
            @include('backslash4::admin.media.no-dashboard.table', ['appModel'=>$appModel, 'items'=>$items])
        @endif
        </div>
    </x-bs-card>

    <x-bs-modal.delete-post-item 
        :tableName="$tableName"
        title="Delete Media Item"
        itemname="Media Item"
        message="Are you sure you want to delete this media item?<br />If it is still being used those entries will no longer display the media.<br />This action cannot be undone."
    />