<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class UserController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = User::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::users.index'))
            return view('tenant::users.index')->with('items', $items);
        //else

        if(view()->exists('users.index'))
            return view('users.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        if( empty(Request()->preview) 
            || empty(User::allowPreviewAlgorithm()) 
            ||  (Request()->preview!=hash( User::allowPreviewAlgorithm(), end($params)) ) )
        {
            $item = User::where('slug', end($params))->active()->first();
        } else
        {
            // preview param exists and matches the slug's hash so allow any pages
            $item = User::where('slug', end($params))->first();
        }

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::users.view'))
            return view('tenant::users.view')->with('item', $item);
        //else

        if(view()->exists('users.view')) {
            return view('users.view')->with('item', $item);
        }
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }

    /**
     * Handle an authentication attempt.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function authenticate(Request $request)
    {
        $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);
 
        if (Auth::guard('web')->attempt($credentials))
        {

            $this->postLoginProcess();
            if(! empty(Request()->redirect)) {
                return redirect(Request()->redirect);
            }

            return redirect(config('backslash4.login-redirect','/'));
        }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ])->onlyInput('email');
    }

    /**
     * Called after logging in but before the redirect, override in your app
     * @return void
     */
    public function postLoginProcess() : void
    {   //does nothing by default
    }

    public function logout()
    {
        $this->preLogoutProcess();
        Auth::guard('web')->logout();
        $this->postLogoutProcess();

        if(! empty(Request()->redirect)) {
            return redirect(Request()->redirect);
        }

        return redirect(config('backslash4.logout-redirect','/'));
    }
    
    /**
     * Called after immediately before logging out, override in your app
     * @return void
     */
    public function preLogoutProcess() : void
    {   //does nothing by default
    }

    /**
     * Called after immediately after logging out, but before the redirect, override in your app
     * @return void
     */
    public function postLogoutProcess() : void
    {   //does nothing by default
    }
}