@props([
	'id' => 'file',
	'name' => 'file',
	'required' => false,
    'group' => null,
    'type' => null,
    'value' => null,
    'folder' => null,
    'filerequirements' => null,
])
@php
    $files=[];
    if(!empty($value))
        $files = json_decode($value, true);

    $attributes = $attributes
        ->merge([
        ])
        ->class([
        ]);
@endphp

<input type="file" {{ $attributes }} name="{{ $name }}" id="{{ $id }} {{ ($required) ? 'required' : '' }}"/>

<x-bs-form.group class="{{ $group['class'] }}">
    <input {{ $required }} {{ $attributes }}  id="{{ $id }}" type="{{ $type }}" value="{{ $value }}"/>
    <x-bs-tag-list data-tag-list="{{ $id }}">
        <x-bs-tags.file />
        @if($files)
            @foreach($files as $file)
                <x-bs-tags.file 
                    :$file
                    :$href
                />
            @endforeach
        @endif
        <x-bs-tag
            icon="plus"
            label="Add file"
            type="button"
            data-a11y-dialog-show="file-picker-{{ $id }}-modal"
            data-action="add-file"
        />
    </x-bs-tag-list>

    <x-bs-modal.file-picker-modal id="file-picker-{{ $id }}-modal" data-for="{{ $id }}" :folder=$folder :filerequirements=$filerequirements />
</x-bs-form.group>