#!/bin/bash

# Default sitemap URL
sitemap_url=""

# Parse command-line arguments
for arg in "$@"; do
  case "$arg" in
    --sitemap=*)
      sitemap_url="${arg#*=}"
      ;;
    *)
      echo "Invalid option: $arg" >&2
      exit 1
      ;;
  esac
done

# Check if sitemap URL is provided
if [[ -z "$sitemap_url" ]]; then
  echo "Please provide a sitemap URL using the --sitemap option."
  exit 1
fi

# Fetch the sitemap and extract the URLs
sitemap=$(curl -s "$sitemap_url" | xmllint --xpath '//*[local-name()="loc"]/text()' -)

# Iterate over each URL and ping it
for url in $sitemap; do
  response_code=$(curl -s -o /dev/null -w "%{http_code}" "$url")
  echo "URL: $url | Response code: $response_code"
done
