@props([
    'icon' => null,
    'label' => null,
    'options' => null,
    'positionX' => 'left',
    'positionY' => 'bottom',
    'width' => '10rem'
])

@php
    $attributes = $attributes
        ->merge([
            'aria-expanded' => 'false',
            'data-action' => 'dropdown',
            'type' => 'button'
        ])
        ->class([
            'tag'
        ]);
@endphp

<x-bs-dropdown :positionX=$positionX :positionY=$positionY style="--dropdown-width: {{ $width }}">
    <button {{ $attributes }}>
        @if ($icon)
            <x-bs-icon 
                :icon=$icon
                size="xs" 
            />
        @endif
        @if($label || !$slot->isEmpty())
            <div class="tag__label">
                {{ $label ?? $slot }}
            </div>
        @endif
        <x-bs-icon 
            icon="chevron-down"
            size="sm"
        />
    </button>
    @if ($options)
        <x-slot name="options">
            {{ $options }}
        </x-slot>
    @endif
</x-bs-dropdown>