<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Enquiry;

class EnquiryController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = Enquiry::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::enquiries.index'))
            return view('tenant::enquiries.index')->with('items', $items);
        //else

        if(view()->exists('enquiries.index'))
            return view('enquiries.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        $item = Enquiry::where('slug', end($params))->active()->first();

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::enquiries.view'))
            return view('tenant::enquiries.view')->with('item', $item);

        if(view()->exists('enquiries.view'))
            return view('enquiries.view')->with('item', $item);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
}
