<x-bs-dashboard>
    <div class="display-flex flex-col items-start lg:flex-row lg:justify-between">
        <div class="display-flex flex-col">
            <h1 class="font-semi-bold text-gray-900 text-3xl">Media library</h1>
            <p class="mt-1 text-gray-600">View media that has been uploaded to this website.</p>
            @php( $extra = ($appModel)::getExtraIndexHeaderView() )
            @php( $hidden = [] )
            @if(!empty($extra))
                <p class="mt-1 text-body-tertiary text-sm">{!! $extra !!}</p>
            @endif
        </div>
        @if($showAdminSearch || $showDropDownSearches)
            <x-bs-js.remove-url-params />
        @endif
        <div class="mt-4 lg:mt-0">
            <x-bs-button 
                href="{{ route('admin.mediamanager.create') }}"
                icon="plus"
                iconPosition="start"
                size="md"
                text="Add new" 
                theme="primary"
            />
        </div>
    </div>
    <hr class="divider my-6 md:my-8" />
    <x-bs-card>
        <x-bs-card.header>
            <x-bs-filters x-data="{ open: false }">
                @if($showAdminSearch)
                    <x-bs-filters.item class="lg:display-none" data-role="search" data-filter="search">
                        <x-bs-index-search 
                            label="Search all {{ str_replace('_', ' ', $tableName) }}"
                            labelVisible="true"
                        />
                    </x-bs-filters.item>
                @endif
                <x-bs-filters.item data-filter="toggle">
                    <x-bs-button
                        type="button"
                        text="Filters"
                        theme="secondary"
                        x-on:click="open = !open"
                    />
                </x-bs-filters.item>
                <x-bs-filters.dropdown x-show="open">
                    @if($showAdminSearch)
                        <x-bs-filters.item class="display-none lg:display-flex" data-role="search" data-filter="search">
                            <x-bs-index-search 
                                label="Search all {{ str_replace('_', ' ', $tableName) }}"
                                labelVisible="true"
                            />
                        </x-bs-filters.item>
                    @endif
                    @if($showDropDownSearches)
                        <x-bs-filter-search
                            :isTabbedModule=false
                            :searches=$dropDownSearches 
                            :lists=$dropDownSearchLists 
                            :model=$appModel
                            :$hidden
                        />
                    @endif
                </x-bs-filters.dropdown>
                @if($showAdminSearch || $showDropDownSearches)
                    <x-bs-js.remove-url-params />
                @endif
            </x-bs-filters>
        </x-bs-card.header>
        @php( $extraColumnsA = ($appModel)::getExtraListingColumnsA() )
        @php( $extraColumnsB = ($appModel)::getExtraListingColumnsB() )
        <x-bs-table>
            <x-bs-table.head>
                <x-bs-table.row>
                    <x-bs-table.cell class="[ w-full md:w-auto ]">
                        Preview
                    </x-bs-table.cel>
                    <x-bs-table.cell class="[ display-none lg:display-table-cell ]">
                        Path
                    </x-bs-table.cell>
                    <x-bs-table.cell class="[ display-none md:display-table-cell ]">
                        Date uploaded
                    </x-bs-table.cell>
                    <x-bs-table.cell></x-bs-table.cell>
                </x-bs-table.row>
            </x-bs-table.head>
            <x-bs-table.body>
                @foreach ($items as $item)
                    @include(   'backslash4::admin.media.index-item-row', 
                                ['extraColumnsA' => $extraColumnsA, 'extraColumnsB' => $extraColumnsB]
                            )
                @endforeach
            </x-bs-table.body>
        </x-bs-table>
        <x-bs-card.footer>
            <x-bs-pagination 
                :items=$items 
            />
        </x-bs-card.footer>
    </x-bs-card>

    <x-bs-modal.delete-post-item 
        :tableName="$tableName"
        title="Delete Media Item"
        itemname="Media Item"
        message="Are you sure you want to delete this media item?<br />If it is still being used those entries will no longer display the media.<br />This action cannot be undone."
    />
</x-bs-dashboard>