<x-bs-dashboard>
    <h1 class="font-medium text-body text-xl md:text-2xl">Welcome back, {{ @Auth::guard('admin')->user()->firstName }}</h1>
    <p class="mt-1 text-body-tertiary text-sm">Your website overview and recent activity.</p>
    <hr class="divider my-6 md:my-8" />
    @if (isset($widgetSections))
        @foreach($widgetSections as $section)
            <p>{{ $section['name'] }}</p>
        @endforeach
    @endif

    @if (isset($widgets))
        @php
            $actions = collect($widgets)->filter(function ($widget) {
                return $widget['type'] === 'bs-dashboard-widget.action';
            })->all();
            $information = collect($widgets)->filter(function ($widget) {
                return $widget['type'] != 'bs-dashboard-widget.action';
            })->all();
        @endphp
        @if (!empty($actions))
            <x-bs-grid :columns="['xs' => '1', 'lg' => '2']" :gap="['xs' => '4', 'lg' => '6']">
                <x-bs-grid.item :columnSpan="['xs' => '1']">
                    @foreach($actions as $action)
                        <x-dynamic-component 
                            class="lg:col-span-1" 
                            :component="$action['type']" 
                            :params="$action"
                        />
                    @endforeach
                </x-bs-grid.item>
            </x-bs-grid>
        @endif
        @if (!empty($actions))
            <h3 class="font-medium mt-8 text-body text-lg">Website information</h3>
            <x-bs-divider />
            <x-bs-grid :columns="['xs' => '1', 'lg' => '3']" :gap="['xs' => '4', 'lg' => '6']">
                @foreach($information as $widget)
                    <x-dynamic-component 
                        class="lg:col-span-1" 
                        :component="$widget['type']" 
                        :params="$widget"
                    />
                @endforeach
            </x-bs-grid>
        @endif
    @endif

    @if (!empty($dashboardStatistics))
        @include($dashboardStatistics)
    @endif
</x-bs-dashboard>