/**-----------------------
 *  INSERT INDENTED BLOCK
 * --------- NUNTIS v0.001
 */
/* START CONFIG */
var nicBlockOptions = {
	buttons : {
		'iblock' : {name : 'Insert Block', type : 'nicBlockButton', noClose : true}
	}
	/* NICEDIT_REMOVE_START */
	,iconFiles : {'iblock' : '/js/iblock.gif'}
	/* NICEDIT_REMOVE_END */
};
/* END CONFIG */

var nicBlockButton = nicEditorAdvancedButton.extend({
  addPane : function() {
	var colorList = {0 : '00',1 : '33',2 : '66',3 :'99',4 : 'CC',5 : 'FF'};
	var colorItems = new bkElement('DIV').setStyle({width: '270px'});
	
	for(var r in colorList) {
		for(var b in colorList) {
			for(var g in colorList) {
				var colorCode = '#'+colorList[r]+colorList[g]+colorList[b];
				var colorSquare = new bkElement('DIV').setStyle({'cursor' : 'pointer', 'height' : '15px', 'float' : 'left'})
										.appendTo(colorItems);
				var colorBorder = new bkElement('DIV').setStyle({border: '2px solid '+colorCode})
										.appendTo(colorSquare);
				var colorInner = new bkElement('DIV')
										.setStyle({backgroundColor : colorCode, overflow : 'hidden', width : '11px', height : '11px'})
										.addEvent('click',this.colorSelect.closure(this,colorCode))
										.addEvent('mouseover',this.highlight.closure(this,colorBorder, '#'+contrastingColor(colorCode.substr(1))))
										.addEvent('mouseout',this.highlight.closure(this,colorBorder,colorCode))
										.appendTo(colorBorder);
					
				if(!window.opera)
				{	colorSquare.onmousedown = colorInner.onmousedown = bkLib.cancelEvent;
				}
			}	
		}	
	}
	var colorSquare = new bkElement('DIV')
							.setStyle({'cursor' : 'pointer', 'height' : '15px', 'float' : 'left'})
							.appendTo(colorItems);
	var colorBorder = new bkElement('DIV')
							.setStyle({border: '1px solid white'})
							.appendTo(colorSquare);
	var colorInner = new bkElement('DIV')
							.setStyle({backgroundColor : '#FFF', overflow : 'hidden', width : '22px', height : '11px', fontSize: '9px'})
							.addEvent('click',this.cleariblock.closure(this))
							.addEvent('mouseover',this.highlight.closure(this,colorBorder,'#000'))
							.addEvent('mouseout',this.highlight.closure(this,colorBorder,'#FFF'))
							.setContent('OFF')
							.appendTo(colorBorder);
		
	this.pane.append(colorItems.noSelect());
  },
  cleariblock : function()
  { this.removePane();
	var p = this.ne.selectedInstance.selElm().parentTag('P');
	if(p)
	{ p.setAttributes({ style:'' });
	}
  },
  colorSelect : function(c)
  { var contrast = '#'+contrastingColor(c.substr(1));
	this.removePane();
	
	var style = "background-color:"+c+";margin:1em;padding:1em;color:"+contrast+";border-radius:1em;border:solid 1px black;";
	var p = this.ne.selectedInstance.selElm().parentTag('P');

	if(p)
	{ p.setAttributes({ style, niceditiblock:"1" });
	} else
	{ this.ne.nicCommand('insertHTML','<p niceditiblock="1" style="'+style+'">indented para</p>');
	}
  },
  highlight : function(colorBorder,colorCode)
  { colorBorder.setStyle({border : '2px solid '+colorCode});
  }
});

function contrastingColor(color)
{ return (luma(color) >= 165) ? '000' : 'fff';
}
function luma(color) // color can be a hx string or an array of RGB values 0-255
{ var rgb = (typeof color === 'string') ? hexToRGBArray(color) : color;
  return (0.2126 * rgb[0]) + (0.7152 * rgb[1]) + (0.0722 * rgb[2]); // SMPTE C, Rec. 709 weightings
}
function hexToRGBArray(color)
{ if (color.length === 3)
    color = color.charAt(0) + color.charAt(0) + color.charAt(1) + color.charAt(1) + color.charAt(2) + color.charAt(2);
  else if (color.length !== 6)
    throw('Invalid hex color: ' + color);

  var rgb = [];
  for (var i = 0; i <= 2; i++)
    rgb[i] = parseInt(color.substr(i * 2, 2), 16);

  return rgb;
}
nicEditors.registerPlugin(nicPlugin,nicBlockOptions);
