@props([    
    'id' => null,
    'requirements' => null,
    'size' => null,
    'accept' => '',
    'disabled' => false
])

@php
    $attributes = $attributes
        ->merge([
            'data-disabled' => $disabled
        ])
        ->class([
            'dropzone'
        ]);
@endphp

<div {{ $attributes }} @if($accept) accept="{{ $accept }}" @endif>
    <div class="dropzone__inner">
        <x-bs-featured-icon 
            class="mb-3" 
            icon="upload" 
            size="md"
            variant="circle"
        />
        <p class="text-body-tertiary"><a class="font-semi-bold text-link" href="#">Click to upload</a> or drag and drop</p>
        @if($requirements)
            <p class="text-gray-500">{{ $requirements }} (Max Size {{ Clevercherry\Backslash4\Backslash4::format_file_upload_max_size() }})</p>
        @endif
    </div>

    <div class="sr-only">
        <input class="drop-zone__input" {{ $id ? "id=$id" : '' }} type="file" @if($accept) accept="{{ $accept }}" @endif multiple="" autocomplete="off" tabindex="-1">
    </div>
</div>