@props([    
    'items' => [],
    'span' => 2,
    'path' => null,
    'route' => null
])

@php
    if($route!=null)
        $items->withPath(route($route)); //obsolete send path please
    elseif($path!=null)
        $items->withPath($path);
    
    $attributes = $attributes
        ->merge([    
        ])
        ->class([
            'pagination'
        ]);
@endphp

<ul {{ $attributes }}>
    <li class="pagination__item" data-type="previous">
        @if ($items->onFirstPage())
            <x-bs-button 
                class="display-none lg:display-flex"
                disabled="true"
                icon="arrow-left"
                iconPosition="start"
                sixe="md"
                theme="secondary"
                type="button">
                Previous
            </x-bs-button>
            <x-bs-button 
                class="lg:display-none"
                disabled="true"
                icon="arrow-left"
                iconPosition="only"
                sixe="md"
                theme="secondary"
                type="button">
                <span class="sr-only">Previous page</span>
            </x-bs-button>
        @else
            <x-bs-button 
                class="display-none lg:display-flex"             
                icon="arrow-left"
                iconPosition="start"
                sixe="md"
                theme="secondary" 
                href="{{ $items->previousPageUrl() }}">
                Previous
            </x-bs-button>
            <x-bs-button 
                class="lg:display-none"
                icon="arrow-left"
                iconPosition="only"
                sixe="md"
                theme="secondary"
                href="{{ $items->previousPageUrl() }}">
                <span class="sr-only">Previous page</span>
            </x-bs-button>
        @endif
    </li>

    @if (($items->currentPage()-$span) > 1)
        <li class="pagination__item" data-type="page">
            <a class="pagination__link" href="{{ $items->url(1) }}">1</a>
        </li> 
        @if (($items->currentPage()-$span) > 2)
            <li class="pagination__item" data-type="page" aria-hidden="true">…</li> 
        @endif
    @endif

    @for($i=-$span; $i<=$span; $i++)
        @if( ($items->currentPage()+$i)>0 && ($items->currentPage()+$i)<=$items->lastPage() )
            <li class="pagination__item" data-type="page">
                <a class="pagination__link" 
                    @if($i==0)
                        aria-current="true"
                    @else
                        href="{{ $items->url($items->currentPage()+$i) }}"
                    @endif>
                {{ $items->currentPage()+$i }} 
                </a>
            </li> 
        @endif
    @endfor

    <li class="pagination__summary">
        Page {{ $items->currentPage() }}  of {{ $items->lastPage() }} 
    </li>

    @if($items->lastPage() > ($items->currentPage()+$span))
        @if(($items->currentPage()+$span)<($items->lastPage()-1))
            <li class="pagination__item" data-type="page" aria-hidden="true">…</li>
        @endif
        <li class="pagination__item" data-type="page">
            <a class="pagination__link" href="{{ $items->url($items->lastPage()) }}">
                {{ $items->lastPage() }} 
            </a>
        </li> 
    @endif

    <li class="pagination__item" data-type="next">
        @if ($items->hasMorePages())
            <x-bs-button 
                class="display-none lg:display-flex"
                icon="arrow-right"
                iconPosition="end"
                
                theme="secondary" 
                href="{{ $items->nextPageUrl() }}">
                Next
            </x-bs-button>
            <x-bs-button 
                class="lg:display-none"
                icon="arrow-right"
                iconPosition="only"
                
                theme="secondary"
                href="{{ $items->nextPageUrl() }}">
                <span class="sr-only">Next page</span>
            </x-bs-button>
        @else
            <x-bs-button 
                class="display-none lg:display-flex" 
                disabled="true"
                icon="arrow-right"
                iconPosition="end"
                sixe="md"
                theme="secondary" 
                href="{{ $items->nextPageUrl() }}">
                Next
            </x-bs-button>
            <x-bs-button 
                class="lg:display-none"
                disabled="true"
                icon="arrow-right"
                iconPosition="only"
                sixe="md"
                theme="secondary"
                href="{{ $items->nextPageUrl() }}">
                <span class="sr-only">Next page</span>
            </x-bs-button>
        @endif
    </li> 
</ul>