@props([
    'direction' => 'col',
    'icon' => [
        'icon' => null,
        'size' => 'lg',
        'theme' => 'primary',
        'shape' => 'circle-outline'
    ],
    'title' => null,
    'text' => null
])


@php
    $icon = array_merge([
        'icon' => null,
        'size' => 'lg',
        'theme' => 'primary',
        'shape' => 'circle-outline'
    ], $icon);

    $attributes = $attributes
        ->merge([
            'data-direction' => $direction
        ])
        ->class([
            'modal__header',
        ]);
@endphp


<div {{ $attributes }}>
    @if (!empty($icon['icon']))
        <x-bs-modal.header-icon>
            <x-bs-featured-icon 
                :icon="$icon['icon']"
                :shape="$icon['shape']"
                :size="$icon['size']"
                :theme="$icon['theme']"
            />
        </x-bs-modal.header-icon>
    @endif
    @if (!empty($title) || !empty($text))
        <x-bs-modal.header-content>
            @if (!empty($title))
                <h2 class="font-semi-bold text-body text-lg">{!! $title !!}</h2>
            @endif
            @if (!empty($text))
                <p class="mt-1 text-body-secondary text-sm">{!! $text !!}</p>
            @endif
        </x-bs-modal.header-content>
    @endif
</div>