@foreach($item->getFillableForEditTabs() as $value)
    @php
        $attr = $item->getAttribute($value);
        $label = Str::title(Str::replace('_',' ',Str::replace('-',' ',Str::snake($value))));
    @endphp
    @switch($value)
        @case('name')
        @case('title')
            @if(!$item->hasBlocks() && !empty($attr))
                <h1>{{ $attr }}</h1>
            @endif
            @break
        @case('description')
        @case('content')
            @if(!$item->hasBlocks() && !empty($attr))
                <h1>{{ $attr }}</h1>
            @endif
            @break
        @case('parent')       {{-- these fields are not visible --}}
        @case('id')
        @case('slug')
        @case('active')
        @case('summary')
        @case('created_at')
        @case('updated_at')
            @break
        @default
            @if( !Str::startswith($value, 'media-') && ($value!='media') )
            <p>
            {{ $label }} : {{ $attr }}
            </p>
            @endif
    @endswitch
@endforeach
