@props([
    'params' => [],
])

<div class="card">
    <div class="display-grid grid-cols-3 p-4 md:p-6">
        <div class="col-span-2">
            @if (@$params['heading'])
                <h2 class="font-medium text-gray-900 text-md">{{ @$params['heading'] }}</h2>
            @endif
            @if (@$params['figure'])
                <p class="font-semi-bold mt-5 text-gray-900 text-2xl md:mt-6">{{ @$params['figure'] }}</p>
            @endif
            @if (@$params['trend'] == 'increase')
                <div class="display-flex flex-row items-center mt-4">
                    <x-bs-badge class="mr-2" theme="success">
                        <x-bs-icon 
                            class="fill-success-500 h-4 mr-2 w-4"
                            icon="arrow-up" />
                        {{ @$params['change'] }}
                    </x-bs-badge>
                    @if (@$params['period'])
                        <span class="text-gray-600">{{ @$params['period'] }}</span>
                    @endif
                </div>
            @else
                <div class="display-flex flex-row items-center mt-4">
                    <x-bs-badge class="mr-2" theme="error">
                        <x-bs-icon 
                            class="fill-error-500 h-4 mr-2 w-4"
                            icon="arrow-down" />
                        {{ @$params['change'] }}
                    </x-bs-badge>
                    @if (@$params['period'])
                        <span class="text-gray-600">{{ @$params['period'] }}</span>
                    @endif
                </div>
            @endif
        </div>
        <div class="col-span-1 display-flex items-end justify-end">
            @if (@$params['trend'] == 'increase')
            <svg class="h-12 w-auto md:h-16" viewBox="0 0 94 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M93.0002 1.00005C78.0532 2.24564 77.1276 32.0657 62.3336 35.5001C50.1341 38.3321 43.9567 22.2562 31.6669 24.0001C18.3368 25.8915 14.0711 42.6431 1.00024 47.0001H93.0002V1.00005Z" fill="#ECFDF3"/>
                <path d="M93.0002 1.00005C78.0532 2.24564 77.1276 32.0657 62.3336 35.5001C50.1341 38.3321 43.9567 22.2562 31.6669 24.0001C18.3368 25.8915 14.0711 42.6431 1.00024 47.0001H93.0002V1.00005Z" fill="url(#paint0_linear_3_37)"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M93.997 0.88033C94.041 1.40869 93.6487 1.87271 93.1207 1.91674C89.7387 2.19881 87.0937 4.08939 84.765 7.00241C82.4201 9.93561 80.4831 13.7954 78.4976 17.8411C78.4048 18.0302 78.312 18.2196 78.2189 18.4094C76.3429 22.236 74.4076 26.1835 72.0616 29.4091C69.5916 32.8052 66.5826 35.5215 62.5641 36.4552C55.9671 37.988 51.0178 34.352 46.4594 30.9374C46.398 30.8914 46.3367 30.8455 46.2755 30.7996C41.6621 27.3429 37.4047 24.1529 31.7881 24.9505C25.5122 25.8418 21.3229 30.2238 16.9296 35.2276C16.6652 35.5286 16.4002 35.832 16.1339 36.1367C12.0519 40.8081 7.68171 45.8093 1.26276 47.9508C0.760207 48.1185 0.217002 47.8466 0.0494824 47.3436C-0.118037 46.8407 0.153566 46.297 0.656123 46.1293C6.56249 44.1589 10.6066 39.5378 14.7712 34.779C15.0098 34.5063 15.2488 34.2333 15.4885 33.9602C19.836 29.0088 24.4525 24.0531 31.5186 23.0496C37.931 22.1389 42.7777 25.7755 47.202 29.0951C47.3381 29.1972 47.4737 29.299 47.6089 29.4003C52.2697 32.8916 56.5171 35.8891 62.1303 34.5849C65.5153 33.7985 68.1748 31.4907 70.5106 28.2792C72.7555 25.1926 74.6238 21.3828 76.5252 17.5054C76.6087 17.3353 76.6922 17.165 76.7758 16.9946C78.7429 12.9863 80.7679 8.92915 83.2671 5.80291C85.7824 2.6565 88.8633 0.345173 92.9614 0.00336942C93.4893 -0.0406608 93.953 0.351968 93.997 0.88033Z" fill="#12B76A"/>
                <defs>
                    <linearGradient id="paint0_linear_3_37" x1="47.0002" y1="1.00005" x2="47.0002" y2="47.0001" gradientUnits="userSpaceOnUse">
                        <stop offset="0.697917" stop-color="white" stop-opacity="0"/>
                        <stop offset="1" stop-color="white"/>
                    </linearGradient>
                </defs>
            </svg>
            @else
                <svg class="h-12 w-auto md:h-16" viewBox="0 0 94 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0 1C15.1095 2.27266 16.0452 32.741 31 36.25C43.332 39.1436 49.5766 22.7183 62 24.5C75.4753 26.4326 79.7875 43.5484 93 48H0V1Z" fill="#FEF3F2"/>
                    <path d="M0 1C15.1095 2.27266 16.0452 32.741 31 36.25C43.332 39.1436 49.5766 22.7183 62 24.5C75.4753 26.4326 79.7875 43.5484 93 48H0V1Z" fill="url(#paint0_linear_3_37)"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M0.00253785 0.666913C0.0357015 0.266641 0.385199 -0.0308034 0.783163 0.00255257C4.81235 0.340265 7.85428 2.6218 10.359 5.77051C12.8516 8.90393 14.876 12.9771 16.8555 17.0306C16.9408 17.2053 17.026 17.3799 17.1111 17.5544C19.0189 21.4641 20.9052 25.3297 23.1742 28.4649C25.5388 31.7322 28.2559 34.1148 31.7379 34.9278C37.5035 36.274 41.8608 33.1656 46.5326 29.6487C46.661 29.552 46.7897 29.455 46.9187 29.3578C51.3851 25.9907 56.1823 22.3744 62.5271 23.2799C69.5302 24.2793 74.1168 29.2126 78.4923 34.2206C78.737 34.5007 78.981 34.781 79.2249 35.061C83.3992 39.8553 87.5048 44.5707 93.5054 46.5826C93.8842 46.7096 94.089 47.1215 93.9627 47.5025C93.8364 47.8836 93.4269 48.0895 93.0481 47.9625C86.6611 45.8211 82.3096 40.8177 78.1975 36.0894C77.9328 35.7851 77.6692 35.482 77.406 35.1808C72.9959 30.1331 68.7314 25.6344 62.3239 24.72C56.5791 23.9001 52.2262 27.1782 47.618 30.6484C47.5451 30.7033 47.4721 30.7583 47.3991 30.8132C42.8045 34.272 37.9181 37.864 31.4108 36.3447C27.4513 35.4201 24.4708 32.728 22.005 29.3209C19.6597 26.0804 17.723 22.1105 15.8343 18.2392C15.7419 18.0498 15.6497 17.8607 15.5574 17.6719C13.5641 13.5901 11.6061 9.6664 9.22983 6.67922C6.86572 3.70732 4.15238 1.74453 0.663067 1.45207C0.265103 1.41871 -0.0306258 1.06719 0.00253785 0.666913Z" fill="#F04438"/>
                    <defs>
                        <linearGradient id="paint0_linear_3_37" x1="46.5" y1="1" x2="46.5" y2="48" gradientUnits="userSpaceOnUse">
                            <stop offset="0.641167" stop-color="white" stop-opacity="0"/>
                            <stop offset="1" stop-color="white"/>
                        </linearGradient>
                    </defs>
                </svg>
            @endif
        </div>
    </div>
</div>