///CartControl Object
export default class CartControl
{   //this does now work -- use in preference to the ordinary CartControl module

    cc_callback = null;
    cc_url = '/ajax/amend-basket';
    cc_actionSuffix = 'cart';

    constructor(url='/ajax/amend-basket', actionSuffix="cart", callback=null) {
        //url the ajax call -- you will need to add this to your app routes
        //actionSuffix the data-action suffic for the below click events
        //callback a function of ther form
        //const fav_callback = (event, xhr) => { ... ... }
        //where event is the original click event, and xhr is null for the click, and the response after the xhr onload

        this.cc_callback = callback;
        this.cc_url = url;
        this.cc_actionSuffix = actionSuffix;

        document.addEventListener('click', (event) => {
            if(event.target.matches(`[data-action=add-to-${actionSuffix}]`)) {
                event.preventDefault();
                this.cc_add(event);
            } else if(event.target.matches(`[data-action=subtract-from-${actionSuffix}]`)) {
                event.preventDefault();
                this.cc_subtract(event);
            } else if(event.target.matches(`[data-action=remove-from-${actionSuffix}]`)) {
                event.preventDefault();
                this.cc_remove(event);
            } else if(event.target.matches(`[data-action=set-qty-${actionSuffix}]`)) {
                event.preventDefault();
                this.cc_setqty(event);
            } else if(event.target.matches(`[data-action=toggle-${actionSuffix}]`)) {
                event.preventDefault();
                this.cc_toggle(event);
            } //else bs4.log('ccdev 030 - click not trapped in cartcontrol');
        });
        //numbers in inputs -- sometimes this might be enough
        document.addEventListener('change', (event) => {
            if(event.target.matches(`input[data-action=set-qty-${actionSuffix}]`)) {
                event.preventDefault();
                event.target.dataset.qty = event.target.value;
                this.cc_setqty(event);
            } //else bs4.log('ccdev 030 - click not trapped in cartcontrol');
        });
    }  //end constrictor

    cc_add = (event, action='add-qty', subtractFlag=false) =>{
        event.preventDefault();
        if(this.cc_callback!=null)
            this.cc_callback(event,null); //callback swith xhr set to null ie. we have a click the event should be able to determine what it was

        const xhr = new XMLHttpRequest();
        xhr.sourceEvent = event;
        xhr.cc_callback = this.cc_callback;
        xhr.onload = function() {
                if(this.cc_callback!=null)
                    this.cc_callback(event,xhr);
        };

        var formData = new FormData();
        formData.append("id", event.target.dataset.productid);
        var price = event.target.dataset.productPrice;
        if(price==null || price=='')
            price=0.0;
        formData.append("price", price);
        var qty = event.target.dataset.qty;
        if(qty==null || qty=='')
            qty=1;
        if(subtractFlag)
            qty=qty*-1;

        //console.log('ccdev 57 qty ',qty);
        formData.append("qty", qty);
        formData.append("action", action);

        var options = {};
        var opt = event.target.dataset.options_text;
        if(opt!=null)
            options.text = opt.value

        opt = event.target.dataset.options1;
        if(opt!=null)
            options.a =  opt.value;
        
        opt = event.target.dataset.options2;
        if(opt!=null)
            options.b = opt.value;

        if(options!=null)
            formData.append("options", options );
        
        xhr.open("POST", this.cc_url, true);

        var csrf = document.querySelector('meta[name="csrf-token"]');
        if(csrf!=null)
            xhr.setRequestHeader('X-CSRF-TOKEN', csrf.content);
        
        xhr.timeout = 25000; // time in milliseconds
        //console.log('ccdev 81 ',formData);
        //console.table(event.target.dataset);
        xhr.send(formData);

    }
    cc_subtract = (event) =>{
        event.preventDefault();
        this.cc_add(event, 'add-qty', true);
    }
    cc_remove = (event) =>{
        event.preventDefault();
        event.target.dataset.qty="0";
        this.cc_add(event, 'set-qty');  //set qty with zero
    }
    cc_setqty = (event) =>{
        event.preventDefault();
        this.cc_add(event, 'set-qty');  //set qty
    }
    cc_toggle = (event) =>{
        event.preventDefault();
        var qty = event.target.dataset.qty;
        if(qty==null || qty=='' || qty=="0" || qty==0)
        {   //console.log('ccdev cart toggle 0');
            event.target.dataset.qty="1";
            this.cc_add(event, 'set-qty');  //add 1
        } else
        {   //console.log('ccdev cart toggle !0');
            event.target.dataset.qty="0";
            this.cc_add(event, 'set-qty');  //subtract qty on event.target
        }
    }
    formatPrice = (pennies, currency='£') =>
    {
        return currency + Number(pennies/100).toFixed(2);
    }
}