/**
 * tag list editor item 
 */

function bs4AddTagModal(event)
{
    var fgroup = event.target.closest('.form-group');
    fgroup.querySelector('[data-a11y-dialog-show]').click();
}

/**
 * Adds a new tag element to a tag list
 * 
 * @param {Object} event 
 */

const bs4AddTagItem = (event) => {
    const tagId = event.target.getAttribute('data-id');
    const tagName = event.target.getAttribute('data-name');
  
    const fgroup = event.target.closest('.form-group');
    const inp = fgroup.querySelector('input');
  
    const taglist = fgroup.querySelector('[data-role="tag-list"]');
    taglist.insertAdjacentHTML(
      'beforeend',
      `
      <span class="tag" data-id="${tagId}">
        <span class="tag__label">${tagName}</span>
        <button class="tag__action" type="button" data-action="remove-tag">
          <svg class="icon" data-size="xs" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" focusable="false" aria-hidden="true">
            <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
          </svg>
        </button>
      </span>
      `
    );
  
    regenJson(inp, taglist);
}
  
function regenJson(inp, taglist)
{
    var none = taglist.querySelector('[data-id="none"]');
    if(none!=null)
        none.remove();

    var jsValue = JSON.parse('{"ids":[]}');

    var tags = taglist.querySelectorAll('[data-id]');
    if(tags.length==0)
    {
        // taglist.insertAdjacentHTML('beforeend',`<span data-id="none">None&nbsp;</span>`);        
    } else
    {
        tags.forEach(element => {
            var id = element.getAttribute('data-id');
            if(id!='none')
            {
                let number = Number(id);
                //console.log('ccdev 60',id, number);
                if(isNaN(number) || number==null)
                {   //not a number so push as itself (a string most probably)
                    //console.log('ccdev 64',id, number);
                    jsValue.ids.push(id);
                    //console.log('ccdev 66',id, number, jsValue.ids);
                } else
                {   // yes a number worked so push it as a number
                    jsValue.ids.push(number);
                }
            }
        });
            
        console.log('ccdev 41: jsValue', jsValue);
    }
    document.querySelectorAll('button[data-action=remove-tag]').forEach(item => {
        item.addEventListener('click', tagRemoveButtonClick);
    });
    inp.value= JSON.stringify(jsValue);
    if(inp.hasAttribute('bsblockindex'))
    {   //fire the change event to get the block to update
        inp.dispatchEvent(new window.Event('change', { bubbles: true }));
    }
}

function tagRemoveButtonClick(event)
{
    var taglist = event.target.closest('[data-role="tag-list"]');
    var fgroup = taglist.closest('.form-group');
    var inp = fgroup.querySelector('input');
    event.target.closest('span[data-id]').remove();
 
    regenJson(inp, taglist);
}
function bell(vol=0.5, freq=830.6)
{   var context = new AudioContext()
    var o = context.createOscillator();
    o.frequency.value = freq;
    var  g = context.createGain()
    o.connect(g)
    g.connect(context.destination)
    o.start(0)

    g.gain.exponentialRampToValueAtTime(vol, context.currentTime + 0.00001);
    g.gain.exponentialRampToValueAtTime(vol/2, context.currentTime + 0.1);
    g.gain.exponentialRampToValueAtTime(0.00001, context.currentTime + 0.7);
}


/**
 * Filters a tag list when a search term is entered.
 * 
 * @param {Event} event Key down event on search input.
 */

const searchTagList = (event) => {0
    let term = event.target.value.trim().toLowerCase();

    setTimeout(function(target, term) {
        let newTerm = target.value.trim().toLowerCase();

        if(term == newTerm) {   
            // Check if user has stopped typing
            bell(0.1);
            filterTags(target, term);
        }
    },1250, event.target, term);
}


/**
 * Hides tags within a tag list based on a search term.
 * 
 * @param {HTMLElement} target search input
 * @param {String} term search term to filter tag list
 */

const filterTags= (target, term) => {
    const tagList = target.closest('.modal__content').querySelector('.tag-list');
    term = term.trim().toLowerCase();

    let counter=0;
    tagList.querySelectorAll('.tag').forEach((tag) => {
        setTimeout((tag,term)=>{
            // doing this is a timeout means the browser doesn't crash
            // effectively threading each DOM element test
            
            if (term == '')
            {
                //empty termm display all
                tag.style.display = 'flex';
            } else
            {
                let name = tag.dataset.name;
                let label = name;
                if(tag.dataset.islowered !== true)
                {
                    label = name.toLowerCase();
                    if(label != name) //save the data as lowercase - so next search will be faster
                    {  
                        tag.dataset.name = label.toLowerCase();
                        tag.dataset.islowered = true;
                    }
                }

                //tag.classList.remove('sr-only'); //style.display  is 100 times faster
                //tag.classList.add('sr-only');
                tag.style.display = label.includes(term) ? 'flex' : 'none';
            }
        }, 1,tag, term)
        
    })
}

document.addEventListener('DOMContentLoaded', () => {

    document.addEventListener('click', (event) => {
        const target = event.target;
        
        if (target.matches('.tag[data-action=add-tag-modal]'))
        {   bs4AddTagModal(event);
        } else if (target.matches('button[data-action="add-tag-button"]'))
        {   bs4AddTagItem(event);
        } //else bs4.log('ccdev 145 - lick not trapped in tags');
    });

    document.querySelectorAll('.tag__action[data-action=remove-tag]').forEach(item => {
        item.addEventListener('click', tagRemoveButtonClick);
    });
    document.querySelectorAll('input[data-action=tag-modal-search]').forEach(item => {
        item.addEventListener('keyup', searchTagList);
    }); 
});