@props(
    [
        'item' =>null,
        'tab' => null,
        'section' => null
    ]
)
@if(!empty($item))
    @php
        $html = $item->getSectionHtml($tab, $section);
        $viewName = $item->getSectionViewName($tab, $section);
        $componentName = $item->getSectionComponentName($tab, $section);
    @endphp
    @if(!empty($html))
        {!! $html !!}
    @endif
    @if(!empty($viewName))
        @include($viewName, ['item' => $item, 'tab'=> $tab, 'section' => $section])
    @endif
    @if(!empty($componentName))
        <x-dynamic-component 
            :component="$componentName" 
            :$item
            :$tab
            :$section
            />
    @endif
@endif