<?php

namespace Clevercherry\MediaManager\Traits;

use Illuminate\Support\Facades\Schema;
use DB;

trait ModelUpdatedAt
{
    public static function bootModelUpdatedAt()
    {
        static::created(function ($model) {
            self::updateTableUpdatedAt($model);
        });

        static::updated(function ($model) {
            self::updateTableUpdatedAt($model);
        });
    }

    public static function updateTableUpdatedAt($model)
    {
        if(Schema::hasColumn($model->type, 'updated_at')) {
            DB::table($model->type)->where('id', $model->key)->update([
                'updated_at' => \Carbon\Carbon::now(),
            ]);
        }
    }
}