@extends('admin.view')

@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <h2>All News</h2>
            </div>
            <div class="col-md-6">
                <div class="text-right">
                    <a href="/admin/news/create" class="btn btn-success">Create</a>
                </div>
            </div>
        </div>

        <div class="row">
            @foreach(News::getAll() AS $page)
                <div class="col-sm-12">
                    <div class="item">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="row">
                                    <div class="col-sm-12 h3">
                                        <div class="">{!! $page->title !!}</div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="pages-url">
                                            <a target="_blank" class="parent-link" href="{{ url($page->slug) }}">{{ url($page->slug) }}
                                        </div>
                                        <strong>Published:</strong> {{ $page->published }}
                                    </div>
                                </div>
                            </div>
                           
                            <div class="col-sm-6 text-right">
                                <div class="btn">{{ News::statuses()[$page->active] }}
                                </div>
                                
                                <a data-container="body" data-toggle="popover" data-placement="top" data-content="Edit this page." href="{{ route('admin.news.update', ['id' => $page->id]) }}" class="btn btn-primary edit-btn"><i class="fa fa-edit"></i></a>

                                <a href="#" data-href="/admin/news/delete/{{ $page->id }}" data-toggle="modal" class="btn btn-danger" data-target="#confirm-delete"><i class="fa fa-trash"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <!-- Delete modal for all the news -->
    <div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="deleteNews" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header"></div>
                <div class="modal-body">
                    Are you sure you want delete this?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-danger btn-ok">Delete</a>
                </div>
            </div>
        </div>
    </div>

@endsection
