<?php
/**
* Builds arguments for the grid.fetch_data event
*/
namespace Clevercherry\Gridview\Events;

use Illuminate\Http\Request;
use Illuminate\Support\Arr;

use Clevercherry\Gridview\Grid;
use Clevercherry\Gridview\GridInterface;

class UserActionRequested {

    /**
     * @var Request
     */
    public $request;

    /**
     * @var Query
     */
    public $builder;

    /**
     * @var Grid|GridInterface
     */
    public $grid;

    /**
     * @var array
     */
    public $validTableColumns;

    /**
     * @var array
     */
    public $args;

    /**
     * UserActionRequested constructor.
     * 
     * @param GridInterface $grid
     * @param Request $request
     * @param $builder
     * @param $validTableColumns
     * @param mixed ...$args
     */
    public function __construct(GridInterface $grid, Request $request, $builder, $validTableColumns, ...$args) {
        $this->grid = $grid;
        $this->request = $request;
        $this->builder = $builder;
        $this->validTableColumns = $validTableColumns;
        $this->args = Arr::collapse($args);
    }
}