<?php
 
namespace App\Http\Controllers\Admin;
 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Controller;
 
class AdminController extends Controller
{
 
    /**
     * Get Admin Dashboard view
     * @return view
     */
    public function index()
    {
        return view('admin.dashboard');
    }

    /**
     * GET Shows the login form
     * @return view
     */
    public function loginForm()
    {
        return view('vendor.adminlte.login');
    }
 
    /**
     * POST Attempt to login the admin user
     * @param Request $request
     * @return redirect
     */
    public function login(Request $request)
    {
        if (Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password])) {
            return redirect('/admin');
        } else {
            return redirect()->back()->with('password', 'Sorry those credentials were not recognised');
        }
    }
 
    /**
     * POST Logs the user out and returns them to the login screen
     * @return redirect
     */
    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect('/admin/login');
    }

}
