<?php
 
namespace App\Models;
 
use Illuminate\Database\Eloquent\Model;
 
class Enquiry extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'enquiries';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'full_name', 'company_name', 'email', 'phone', 'location', 'type', 'product', 'subject', 'message', 'read', 'notes'
    ];

    const UNREAD = 0;
    const READ = 1;
    const RESOLVED = 2;

    const GENERAL = 0;
    const PRODUCT = 1;
  
    /**
     * Returns an array of all enqueries options
     * @return array
     */
    public static function getAll()
    {
        return self::orderBy('created_at', 'desc')->get();
    }

    /**
     * Returns the text values of that status
     * 
     * @return [array]
     */
    public static function statuses()
    {
        return array(
            self::UNREAD => "Unread",
            self::READ => "Read",
            self::RESOLVED => "Resolved"
        );
    }

    /**
     * Returns the text values of that type
     * 
     * @return [array]
     */
    public static function types()
    {
        return array(
            self::GENERAL => "General",
            self::PRODUCT => "Product Specific"
        );
    }
}
