@extends('admin.view')

@section('content')

	<div class="container-fluid">

        <div class="row">
            <div class="col-md-6">
                <h2>Update Product {!! $item->title !!}</h2>
            </div>
        </div>

        {!! Media::manager('products', 'Products Media Manager', $item->id) !!}

	    <form action="/admin/products/update/{!! $item->id !!}" method="post" enctype="multipart/form-data">
		    @csrf

		    <input type="hidden" name="id" value="{{ $item->id }}">
			<input class="hidden-status" type="hidden" name="status" value="{!! $item->status ? '1' : '0' !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Product Category</label>
            					    <select name="product_category" class="form-control" required>
            				            <option value="" disabled>Select Product Category</option>
            				            @foreach(ProductCategory::getAll() AS $value)
            				                <option value="{{ $value->id }}"
            				                	@if($item->product_category==$value->id )
            		                        		selected
            		                    		@endif
            		                    	>{!! $value->title !!}
            				                </option>
            				            @endforeach
            				        </select>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" class="form-control" required>
                                        <option value="" disabled selected>Select Status</option>
                                        @foreach(Product::statuses() AS $key => $value)
                                            <option value="{{ $key }}"
                                                @if($item->status==$key )
                                                    selected
                                                @endif
                                            >
                                                {!! $value !!}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control" value="{{ $item->name }}" required>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Code</label>
                                    <input type="text" name="code" class="form-control" placeholder="Enter product code" value="{{ $item->code }}" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Price</label>
                                    <input type="number" class="form-control" name="price" placeholder="Enter base price" value="{{ old('price') ?: $item->price }}" required>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Content</label>
                                    <textarea name="content" class="form-control tiny">{{ $item->content }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
            		    <div class="row">
            		   		<div class="col-md-12">
            		            <div class="form-group">
            		            	<label>Seo Title</label>
            		            	<input type="text" name="seo_title" class="form-control" value="{{ $item->seo_title ?: $item->name }}">
            		            </div>
            		        </div>
            		        <div class="col-md-12">
            		            <div class="form-group">
            		                <label>Seo Description</label>
            		                <textarea name="seo_description" class="form-control">{{ $item->seo_description ?: '' }}</textarea>
            		            </div>
            		        </div>
            		    </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-success">Update</button>
                    <a href="/admin/products/prod-cat/{!! $item->product_category !!}" class="btn btn-default">Cancel</a>
                </div>
            </div>

	    </form>
	</div>

@endsection
