<?php
 
namespace App\Models;
 
use Illuminate\Database\Eloquent\Model;
 
class Setting extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'settings';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'setting', 'description', 'type', 'value',
    ];
 
    /**
     * Returns an array of all site settings
     * @return string
     */
    public static function getAll()
    {
        return Setting::orderBy('setting', 'asc')->get();
    }
 
    /**
     * Returns an array of all comma seperated emails specified in the CMS
     * @return string
     */
    public static function internalEmail()
    {
        $emails = Setting::where('setting', 'Internal Email')->first()->value;
        
        return array_map('trim', explode(',', $emails));
    }
 
    /**
     * Returns the contact email specified in the CMS
     * @return string
     */
    public static function email()
    {
        return Setting::where('setting', 'Contact Email')->first()->value;
    }

    /**
     * Returns the contact address in the CMS
     * @return string
     */
    public static function address()
    {
        return Setting::where('setting', 'Contact Location')->first()->value;
    }
 
    /**
     * Returns the contact address in the CMS and replaces commans with <br> tags to put each part of the address onto a new line
     * @return string
     */
    public static function addressLineBreak()
    {
        $address = Setting::where('setting', 'Contact Location')->first()->value;
        $address = str_replace(',', '<br>', $address);
 
        return $address;
    }

    /**
     * Returns the default seo meta title specified in the CMS
     * @return string
     */
    public static function seoTitle()
    {
        return Setting::where('setting', 'Seo Default Title')->first()->value;
    }

    /**
     * Returns the default seo meta description specified in the CMS
     * @return string
     */
    public static function seoDescription()
    {
        return Setting::where('setting', 'Seo Default Description')->first()->value;
    }

    /**
     * Returns the facebook link specified in the CMS
     * @return string
     */
    public static function facebook()
    {
        return Setting::where('setting', 'Facebook')->first()->value;
    }

    /**
     * Returns the instagram link specified in the CMS
     * @return string
     */
    public static function instagram()
    {
        return Setting::where('setting', 'Instagram')->first()->value;
    }

    /**
     * Returns the telephone link specified in the CMS
     * @return string
     */
    public static function telephone()
    {
        return Setting::where('setting', 'Contact Telephone')->first()->value;
    }
 
    /**
     * Returns the google analytics code specified in the CMS
     * @return string
     */
    public static function googleAnalytics()
    {
        return Setting::where('setting', 'Google Analytics')->first()->value;
    }
}
