<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->string('slug')->nullable()->default(null);

            $table->string('seo_title')->nullable();
            $table->text('seo_description')->nullable();

            $table->string('heading')->nullable();
            $table->text('content');
            $table->text('secondary_content')->nullable();

            $table->integer('parent')->nullable();
            $table->boolean('allow_children')->default(0);
            $table->integer('order')->nullable();

            $table->boolean('active')->default(1);
            $table->string('protected')->nullable();

            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(\DB::raw('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
