@extends('admin.view')

@section('content')

    <div class="container-fluid">

        <h2>Update News Page</h2>

        {!! Media::manager('pages', 'Pages Media Manager', $item->id) !!}

        <form action="/admin/pages/update/{{ $item->id }}" method="post" enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="id" value="{{ $item->id }}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" value="{!! $item->title !!}" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Page Heading</label>
                                    <input type="text" name="heading" class="form-control" value="{!! $item->heading !!}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Content</label>
                                    <textarea name="content" class="form-control tiny" >{!! $item->content !!}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Seo Title</label>
                                    <input type="text" name="seo_title" class="form-control" value="{{ $item->seo_title ?: $item->title }}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Seo Description</label>
                                    <textarea name="seo_description" class="form-control">{{ $item->seo_description ?: '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                     <!-- Protected pages will always stay active -->
                    <input type="hidden" name="active" value="1">

                    <button type="submit" class="btn btn-success">Update Page</button>
                    <a href="{{ route('admin.pages.index') }}" class="btn btn-default">Cancel</a>

                </div>
            </div>
        </form>
    </div>

@endsection
