@extends('admin.view')

@section('content')

    <div class="container-fluid">

        <div class="row">
            <div class="col-md-6">
                <h2>Update News Article</h2>
            </div>
            <div class="col-md-6">
                <div class="text-right">
                    <div class="form-group nm">
                        <label>Activate</label>
                        <button type="button" class="btn btn-lg btn-toggle {!! $item->active ? 'active' : '' !!} btn-status" data-toggle="button" aria-pressed="{!! $item->active ? 'active' : 'inactive' !!}" autocomplete="off">
                            <div class="handle"></div>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        {!! Media::manager('news', 'News Media Manager', $item->id) !!}

        <form action="/admin/news/update/{!! $item->id !!}" method="post" enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="id" value="{{ $item->id }}">
            <input class="hidden-status" type="hidden" name="active" value="{!! $item->active ? '1' : '0' !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" value="{!! $item->title !!}"  required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Author</label>
                                    <input type="text" name="author" class="form-control" required value="{{ $item->author }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Snippet</label>
                                    <input type="text" name="snippet" class="form-control" value="{!! $item->snippet !!}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Published</label>
                                    <input type="date" name="published" class="form-control" value="{{ $item->published }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Intro Content</label>
                                    <textarea name="intro_content" class="form-control tiny">{!! $item->intro_content !!}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Secondary Content</label>
                                    <textarea name="secondary_content" class="form-control tiny">{!! $item->secondary_content !!}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>SEO Title</label>
                                    <input type="text" name="seo_title" class="form-control" value="{!! $item->seo_title ?: $item->title !!}">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>SEO Description</label>
                                    <textarea name="seo_description" class="form-control">{!! $item->seo_description ?: '' !!}</textarea>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-success">Update News Article</button>
                    <a href="/admin/news/" class="btn btn-default btn-danger">Cancel</a>
                </div>
            </div>
        </form>
    </div>

@endsection
