/**
 *  Will add the status of the toggle buttons on the forms it exists
 */
$(document).on("click", ".btn-status", function() { 
	var pressed = $(this).attr('aria-pressed');
	
	if(pressed === 'true'){
		$('.hidden-status').attr('value', 1);
	} else if (pressed == 'false') {
		$('.hidden-status').attr('value', 0);
	}
});

/**
 * Reordering of Child Pages
 */
UIkit.util.on('.plot-order-drop', 'stop', function () {
  setTimeout(function() {
	$('.plot-order-drop').each(function(){
	  var i = 0;
	  var type = $(this).attr('order-category');
	  var ids = {};
	  var group = $(this).attr('id');

	  $('#'+group+' > .plot-order-item').each(function(){
		  var id = $(this).attr('order-id');
		  ids[i] = id;
		  i++;
	  });

	  $.ajax({
		  headers: {
			  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		  },
		  url: '/admin/'+type+'/reorder',
		  type: 'post',
		  data: {'ids': ids}
		});
	  });
	}, 200);
});

/**
 * Reordering of Products Categories
 */
UIkit.util.on('.product-cat-order', 'stop', function () {
  setTimeout(function() {
	$('.product-cat-order').each(function(){
	  var i = 0;
	  var ids = {};
	  $('.product-cat-order-item').each(function(){
		  var id = $(this).attr('order-id');
		  ids[i] = id;
		  i++;
	  });

	  $.ajax({
		  headers: {
			  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		  },
		  url: '/admin/product-categories/reorder',
		  type: 'post',
		  data: {'ids': ids}
		});
	  });
	}, 200);
});

/**
 * Reordering of Products 
 */
UIkit.util.on('.product-order', 'stop', function () {
  setTimeout(function() {
	$('.product-order').each(function(){
	  var i = 0;
	  var ids = {};
	  console.log(ids);
	  $('.product-order-item').each(function(){
		  var id = $(this).attr('order-id');
		  ids[i] = id;
		  i++;
	  });

	  $.ajax({
		  headers: {
			  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		  },
		  url: '/admin/products/reorder',
		  type: 'post',
		  data: {'ids': ids}
		});
	  });
	}, 200);
});

/**
 * View products inside the selected product category
 */
$('#product-category-select').change(function () {
	var selected = $(this).val();
	window.location = "/admin/products/prod-cat/" + selected;
});

/**
 *  keep active tab active
 */
$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    localStorage.setItem('activeTab', $(e.target).attr('href'));
});

var activeTab = localStorage.getItem('activeTab');
if(activeTab){
    $('.nav-pills a[href="' + activeTab + '"]').tab('show');
}

// ----------------------- Delete Modals start here ---------------------- //

// Product category and Product delete
$('#confirm-delete').on('click', '.btn-ok', function(e) {
    var $modalDiv = $(e.delegateTarget);
    var href = $(this).data('href');
    $.ajax({
    	headers: {
			 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		url: href,
    	type: 'POST',
    	success: function(data) {
    		location.reload()
		}
    })
});
$('#confirm-delete').on('show.bs.modal', function(e) {
    var data = $(e.relatedTarget).data();
    $('.btn-ok', this).data('href', data.href);
});

// ----------------------- Delete Modals end here ---------------------- //

