@extends('admin.view')

@section('content')

<div class="container-fluid">
	<div class="row">
	    <div class="col-md-6">
	        <h2>Products</h2>
	    </div>
	    <div class="col-md-6">
	        <div class="text-right">
	            <a href="{{ route('admin.products.create') }}" class="btn btn-primary">Create New Product</a>
	        </div>
	    </div>
	</div>
	<div class="row">
	 	<div class="col-md-12">
	        <div class="well">
				<div class="row">
				    <div class="col-md-12">
						<select name="product_category" id="product-category-select" class="form-control" required>
				            <option value="" disabled>Select Product Category</option>
				            @foreach(ProductCategory::getAllWithUncategorised() AS $value)
				                <option value="{{ $value->id }}"
				                	@if($category->id==$value->id )
				                        selected
				                    @endif
				                    >
				                    {!! $value->title !!}
				                </option>
				            @endforeach
				        </select>
				    </div>
				</div>
			</div>
		</div>
	</div>

	<div class="box box-default" data-widget="box-widget">
		<div class="box-header">
			<h3 class="box-title">{{ $category->title }} Products</h3>
		</div>

		<div class="box-body">
			<div class="uk-child-width-1-2@m uk-child-width-1-4@xl uk-grid-small uk-grid-match product-order" uk-sortable="handle: .uk-card" uk-grid>
				@foreach(Product::getAllForCategory($category->id) as $prod)
					<div>
						<div class="uk-card uk-card-default uk-text-center product-order-item" order-id="{{ $prod->id }}">
							<div class="uk-card-media-top">
								@if(Media::countAll(null, 'products', $prod->id, 'thumbnailp') > 0)
						            @php
						                $path = Media::getMedia(null, 'products', $prod->id, 'thumbnailp');
						            @endphp
						            <img src="{{  Storage::url($path[0]->path) }}" alt="...">
						        @else
						            <img src="data:image/png;base64,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" alt="No Image">
						        @endif
							</div>

							<div class="uk-card-body products">
								<h3 class="uk-card-title">{!! $prod->name !!}</h3>
							</div>

							<!-- Status -->
							<div class="published">
								@switch($prod->status)
								    @case(Product::PENDING)
								       <span class="uk-label uk-label-pink">Pending</span>
								    @break
								    @case(Product::ACTIVE)
								       <span class="uk-label uk-label-teal">Active</span>
								    @break
								    @case(Product::SOLD)
								       <span class="uk-label uk-label-burgundy">Sold</span>
								    @break
								    @case(Product::INACTIVE)
								       <span class="uk-label uk-label-red">Inactive</span>
								    @break
								    @case(Product::UNDER_OFFER)
								       <span class="uk-label uk-label-indigo">Under offer</span>
								    @break
								    @default
								    @break
								@endswitch
							</div>

							<div class="uk-card-footer uk-position-bottom">
								<div class="uk-button-group uk-flex uk-flex-around footer-btn-group">
							        <span class="footer-btn"><a href="{{ route('admin.products.update', ['id' => $prod->id]) }}" class="btn btn-primary"><i class="fa fa-eye"></i> view</a></span>
							        <span class="footer-btn">
						    			<a href="#" data-href="/admin/products/delete/{{ $prod->id }}" data-toggle="modal" class="btn btn-default btn-danger" data-target="#confirm-delete"><i class="fa fa-trash"></i> Remove</a>
						    		</span>
							    </div>
							</div>
						</div>
					</div>
				@endforeach
			</div>
	    </div>
	</div>
</div>

<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="deleteProductCategory" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header"></div>
            <div class="modal-body">
              	Are you sure you want delete this Product?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>

@endsection
