@extends('admin.view')

@section('content')

	<div class="container-fluid">

		<div class="row">
            <div class="col-md-6">
	    		<h2>Update Account</h2>
            </div>
            <div class="col-md-6">
                <div class="text-right">
                    <div class="form-group nm">
                        <label>Activate</label>
                        <button type="button" class="btn btn-lg btn-toggle {!! $item->active ? 'active' : '' !!} btn-status" data-toggle="button" aria-pressed="{!! $item->active ? 'active' : 'inactive' !!}" autocomplete="off">
                            <div class="handle"></div>
                        </button>
                    </div>
                </div>
            </div>
        </div>

	    <form action="/admin/accounts/update/{{ $item->id }}" method="post" enctype="multipart/form-data">
		    @csrf

		    <input type="hidden" name="id" value="{{ $item->id }}">
			<div class="row">
			    <div class="col-md-12">
			        <div class="well">
					    <div class="row">
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>First Name</label>
					                <input type="text" name="first_name" class="form-control" value="{!! old('first_name') ?: $item->first_name !!}" required>
					            </div>
					        </div>
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Last Name</label>
					                <input type="text" name="last_name" class="form-control" value="{!! old('last_name') ?: $item->last_name !!}" required>
					            </div>
					        </div>
					    </div>
					</div>
				</div>
			</div>

			<div class="row">
			    <div class="col-md-12">
			        <div class="well">
					    <div class="row">
					        <div class="col-md-4">
					            <div class="form-group">
					                <label>Email</label>
					                <input type="text" name="email" class="form-control" value="{!! old('email') ?: $item->email !!}" required>
					            </div>
					        </div>
					        <div class="col-md-4">
					            <div class="form-group">
					                <label>Contact Number</label>
					                <input type="text" name="contact_number" class="form-control" value="{!! old('contact_number') ?: $item->contact_number !!}" required>
					            </div>
					        </div>
					       	<div class="col-md-4">
					            <div class="form-group">
					                <label>Company Name </label>
					                <input type="text" name="company_name" class="form-control" value="{!! old('company_name') ?: $item->company_name !!}">
					            </div>
					        </div>
					    </div>
					</div>
				</div>
			</div>

			<div class="row">
			    <div class="col-md-12">
			        <div class="well">
					    <div class="row">
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Addresss Line 1</label>
					                <input type="text" name="address_line_one" class="form-control" value="{!! old('address_line_one') ?: $item->address_line_one !!}" required>
					            </div>
					        </div>
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Address Line 2</label>
					                <input type="text" name="address_line_two" class="form-control" value="{!! old('address_line_two') ?: $item->address_line_two !!}">
					            </div>
					        </div>
					    </div>
					</div>
				</div>
			</div>

			<div class="row">
			    <div class="col-md-12">
			        <div class="well">
					    <div class="row">
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Town</label>
					                <input type="text" name="town" class="form-control" value="{!! old('town') ?: $item->town !!}" required>
					            </div>
					        </div>
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>County</label>
					                <input type="text" name="county" class="form-control" value="{!! old('county') ?: $item->county !!}">
					            </div>
					        </div>
					    </div>
					</div>
				</div>
			</div>

			<div class="row">
			    <div class="col-md-12">
			        <div class="well">
					    <div class="row">
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Country</label>
					                <input type="text" name="country" class="form-control" value="{!! old('country') ?: $item->country !!}" required>
					            </div>
					        </div>
					        <div class="col-md-6">
					            <div class="form-group">
					                <label>Postcode</label>
					                <input type="text" name="postcode" class="form-control" value="{!! old('postcode') ?: $item->postcode !!}" required>
					            </div>
					        </div>
					    </div>
					</div>
				</div>
			</div>

			<input class="hidden-status" type="hidden" name="active" value="{!! $item->active ? '1' : '0' !!}">

			<div class="row">
				<div class="col-md-12">
				    <button type="submit" class="btn btn-success">Update Account</button>
				    <a href="{{ route('admin.accounts.index') }}" class="btn btn-default">Cancel</a>
				</div>
			</div>
	    </form>
	</div>

@endsection
