@extends('admin.view')

@section('content')

    <div class="container-fluid">

        <h2>New Page</h2>
        
        {!! Media::manager('pages', 'Pages Media Manager') !!}
        <form action="/admin/pages/create" method="post" enctype="multipart/form-data" create-form>
            @csrf
            
            <input class="hidden-status" type="hidden" name="active" value="{!! old('status') ? '1' : '0' !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" required value="{{ old('title') }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Parent Page</label>
                                    <select name="parent" class="form-control" required>
                                        <option value="" selected disabled>Select a parent</option>
                                        @foreach(Page::parentList() AS $parent)
                                            <option value="{{ $parent->id }}"
                                                @if(old('parent') && old('parent')==$parent->id )
                                                    selected
                                                @endif
                                                >
                                                {!! $parent->title !!}
                                            </option>
                                        @endforeach
                                    </select>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Content</label>
                                    <textarea name="content" class="form-control tiny"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Secondary Content</label>
                                    <textarea name="secondary_content" class="form-control tiny"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Seo Title</label>
                                    <input type="text" name="seo_title" class="form-control" value="{{ old('seo_title') ?: old('title') }}">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Seo Description</label>
                                    <textarea name="seo_description" class="form-control">{{ old('seo_description') ?: '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <label>Activate</label>
            <button type="button" class="btn btn-lg btn-toggle {!! old('status') ? 'active' : 'inactive' !!} btn-status" data-toggle="button" aria-pressed="{!! old('status') ? 'active' : 'inactive' !!}" autocomplete="off">
                <div class="handle"></div>
            </button>
            
            <button type="submit" class="btn btn-success">Create New Page</button>
            <a href="{{ route('admin.pages.index') }}" class="btn btn-default">Cancel</a>

        </form>
    </div>

@endsection
