@extends('admin.view')

@section('content')

    <div class="container-fluid">
        <h2>View Enquiry</h2>
        <form action="/admin/enquiry/update/{{$item->id}}" method="post" enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="id" value="{!! $item->id !!}">

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Type</label>
                                    <input type="text" name="type" class="form-control" value="{!! Enquiry::types()[$item->type] !!}" disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Product</label>
                                    <input type="text" name="product" class="form-control" value="{!! Product::where('id', $item->product)->first()['name'] !!}" disabled>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="full_name" class="form-control" value="{!! $item->full_name !!}" disabled>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" name="email" class="form-control" value="{!! $item->email !!}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Company Name</label>
                                    <input type="text" name="company_name" class="form-control" value="{!! $item->company_name !!}" disabled>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" name="phone" class="form-control" value="{!! $item->phone !!}" disabled>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Location</label>
                                    <input type="text" name="location" class="form-control" value="{!! $item->location !!}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Subject</label>
                                    <input type="text" name="subject" class="form-control" value="{!! $item->subject !!}" disabled>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Message</label>
                                    <textarea name="message" class="form-control" disabled>{!! $item->message !!}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="read" class="form-control" required>
                                        @foreach(Enquiry::statuses() AS $key => $status)
                                            <option value="{{ $key }}"
                                            @if($item->read==$key)
                                                    selected
                                                @endif
                                                >
                                                {!! $status !!}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="well">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea name="notes" class="form-control">{!! isset($item->notes) ? $item->notes : old('notes')!!}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <button type="submit" class="btn btn-success">Update Enquiry</button>
                    <a href="{{ route('admin.enquiries.index') }}" class="btn btn-default">Cancel</a>
                </div>
            </div>
        </form>
    </div>

@endsection
